/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities;

import com.sleepycat.je.ExceptionEvent;
import com.sleepycat.je.ExceptionListener;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import mobac.program.Logging;
import mobac.program.ProgramInfo;
import mobac.program.interfaces.ExceptionExtendedInfo;
import mobac.utilities.I18nUtils;
import mobac.utilities.OSUtilities;
import org.apache.log4j.Logger;

public class GUIExceptionHandler
implements Thread.UncaughtExceptionHandler,
ExceptionListener {
    private static final GUIExceptionHandler instance = new GUIExceptionHandler();
    private static final Logger log = Logger.getLogger(GUIExceptionHandler.class);
    private static final double MB_DIV = 1048576.0;
    private static final String URL_BUGTRACKER = "http://sourceforge.net/p/mobac/bugs/";

    public static void registerForCurrentThread() {
        Thread t = Thread.currentThread();
        log.trace("Registering MOBAC exception handler for thread \"" + t.getName() + "\" [" + t.getId() + "]");
        t.setUncaughtExceptionHandler(instance);
    }

    public static GUIExceptionHandler getInstance() {
        return instance;
    }

    private GUIExceptionHandler() {
    }

    @Override
    public void exceptionThrown(ExceptionEvent paramExceptionEvent) {
        Exception e = paramExceptionEvent.getException();
        log.error("Exception in tile store: " + paramExceptionEvent.toString(), e);
        GUIExceptionHandler.showExceptionDialog(e);
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        GUIExceptionHandler.processException(t, e);
    }

    public static void processException(Throwable e) {
        GUIExceptionHandler.processException(Thread.currentThread(), e);
    }

    public static void processFatalExceptionSimpleDialog(String dialogMessage, Throwable e) {
        log.error(dialogMessage + ": " + e.getMessage(), e);
        Object[] options = new String[]{I18nUtils.localizedStringForKey("Exit", new Object[0]), I18nUtils.localizedStringForKey("dlg_download_show_error_report", new Object[0])};
        int a = JOptionPane.showOptionDialog(null, dialogMessage, I18nUtils.localizedStringForKey("Error", new Object[0]), 0, 0, null, options, options[0]);
        if (a == 1) {
            GUIExceptionHandler.showExceptionDialog(e);
        }
        System.exit(1);
    }

    public static void processException(Thread thread, Throwable t) {
        log.error("Uncaught exception: " + t, t);
        GUIExceptionHandler.showExceptionDialog(thread, t, null);
    }

    public static void processException(Thread thread, Throwable t, AWTEvent newEvent) {
        String eventText = newEvent.toString();
        log.error("Uncaught exception on processing event " + eventText, t);
        if (eventText.length() > 100) {
            String[] parts = eventText.split(",");
            StringWriter sw = new StringWriter(eventText.length() + 20);
            sw.write(parts[0]);
            int len = parts[0].length();
            for (int i = 1; i < parts.length; ++i) {
                String s = parts[i];
                if (s.length() + len > 80) {
                    sw.write("\n\t");
                    len = 0;
                }
                sw.write(s);
            }
            eventText = "Event: " + sw.toString();
        }
        GUIExceptionHandler.showExceptionDialog(thread, t, eventText);
    }

    public static String prop(String key) {
        String s = System.getProperty(key);
        if (s != null) {
            return s;
        }
        return "";
    }

    public static void showExceptionDialog(Throwable t) {
        GUIExceptionHandler.showExceptionDialog(null, Thread.currentThread(), t, null);
    }

    public static void showExceptionDialog(String message, Throwable t) {
        GUIExceptionHandler.showExceptionDialog(message, Thread.currentThread(), t, null);
    }

    public static void showExceptionDialog(Thread thread, Throwable t, String additionalInfo) {
        GUIExceptionHandler.showExceptionDialog(null, thread, t, additionalInfo);
    }

    public static synchronized void showExceptionDialog(String message, Thread thread, Throwable t, String additionalInfo) {
        try {
            String guiText;
            String dialogTitle;
            String dist;
            if (t != null) {
                String thisClassName = GUIExceptionHandler.class.getName();
                for (StackTraceElement ste : t.getStackTrace()) {
                    if (!ste.getClassName().startsWith(thisClassName) || !"showExceptionDialog".equals(ste.getMethodName())) continue;
                    log.error("Recursive error loop detected - aborting");
                    return;
                }
            }
            StringBuilder sb = new StringBuilder(2048);
            if (message != null) {
                sb.append("Error message: " + message + "\n");
            }
            sb.append("Version: " + ProgramInfo.getCompleteTitle());
            sb.append("\nPlatform: " + GUIExceptionHandler.prop("os.name") + " (" + GUIExceptionHandler.prop("os.version") + ")");
            String windowManager = System.getProperty("sun.desktop");
            if (windowManager != null) {
                sb.append(" (" + windowManager + ")");
            }
            if ((dist = OSUtilities.getLinuxDistributionName()) != null) {
                sb.append("\nDistribution name: " + dist);
            }
            sb.append("\nJava VM: " + GUIExceptionHandler.prop("java.vm.name") + " (" + GUIExceptionHandler.prop("java.runtime.version") + ")");
            Runtime r = Runtime.getRuntime();
            sb.append(String.format("\nMax heap size: %3.2f MiB", (double)r.maxMemory() / 1048576.0));
            sb.append("\nCPU cores: " + Runtime.getRuntime().availableProcessors());
            if (thread != null) {
                sb.append("\n\nThread: " + thread.getName());
            }
            if (additionalInfo != null) {
                sb.append("\n\n" + additionalInfo);
            }
            if (t instanceof ExceptionExtendedInfo) {
                ExceptionExtendedInfo ei = (ExceptionExtendedInfo)((Object)t);
                sb.append("\n");
                sb.append(ei.getExtendedInfo());
            }
            JPanel panel = new JPanel(new BorderLayout());
            if (t != null) {
                sb.append("\n\nError hierarchy:");
                for (Throwable tmp = t; tmp != null; tmp = tmp.getCause()) {
                    sb.append("\n  " + tmp.getClass().getSimpleName() + ": " + tmp.getMessage());
                }
                String exceptionName = t.getClass().getSimpleName();
                dialogTitle = "Unexpected Exception: " + exceptionName;
                StringWriter stack = new StringWriter();
                t.printStackTrace(new PrintWriter(stack));
                sb.append("\n\n#############################################################\n\n");
                sb.append(stack.getBuffer().toString());
                sb.append("\n#############################################################");
                guiText = "An unexpected exception occurred (" + exceptionName + ")<br><p>Please create a ticket in the bug tracker on <a href=\"" + URL_BUGTRACKER + "\">SourceForge.net</a><br><b>Please include a detailed description of your performed actions <br>before the error occurred.</b></p>Be sure to include the following information:";
            } else {
                dialogTitle = "System report";
                guiText = "This is a user generated system report.<br><p>It can be used for providing detailed version information <br>in case a new ticket in the bug tracker is created on <a href=\"http://sourceforge.net/p/mobac/bugs/\">SourceForge.net</a><br><b>Please include a detailed description of your problem <br>and what steps are necessary to reproduce the problem.</b></p>";
            }
            JEditorPane text = new JEditorPane("text/html", "");
            text.setOpaque(true);
            text.setBackground(UIManager.getColor("JFrame.background"));
            text.setEditable(false);
            text.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent e) {
                    if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                        return;
                    }
                    try {
                        Desktop.getDesktop().browse(e.getURL().toURI());
                    }
                    catch (Exception e1) {
                        log.error("", e1);
                    }
                }
            });
            panel.add((Component)text, "North");
            try {
                StringSelection contents = new StringSelection(sb.toString());
                ClipboardOwner owner = new ClipboardOwner(){

                    @Override
                    public void lostOwnership(Clipboard clipboard, Transferable contents) {
                    }
                };
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(contents, owner);
                guiText = guiText + "<p>(The following text has already been copied to your clipboard.)</p>";
            }
            catch (RuntimeException x) {
                log.error("", x);
            }
            text.setText("<html>" + guiText + "</html>");
            JCheckBox quickMOBACcb = new JCheckBox("Do not continue and quit program by pressing OK");
            JTextArea info = new JTextArea(sb.toString(), 20, 60);
            info.setCaretPosition(0);
            info.setEditable(false);
            info.setMinimumSize(new Dimension(200, 150));
            panel.add((Component)new JScrollPane(info), "Center");
            panel.add((Component)quickMOBACcb, "South");
            panel.setMinimumSize(new Dimension(700, 300));
            panel.validate();
            JOptionPane.showMessageDialog(null, panel, dialogTitle, 0);
            if (quickMOBACcb.isSelected()) {
                log.warn("User selected to quit MOBAC after an exception");
                System.exit(1);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void installToolkitEventQueueProxy() {
        boolean isLikeJava7 = (double)Float.parseFloat(System.getProperty("java.specification.version")) > 1.6;
        EventQueueProxy eventQueueProxy = new EventQueueProxy();
        try {
            if (isLikeJava7) {
                EventQueue.invokeAndWait(eventQueueProxy);
            } else {
                eventQueueProxy.run();
            }
        }
        catch (Exception e) {
            log.error("", e);
        }
    }

    public static void main(String[] args) {
        try {
            Logging.configureConsoleLogging();
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            throw new RuntimeException("Test", new Exception("Inner"));
        }
        catch (Exception e) {
            GUIExceptionHandler.showExceptionDialog("Test 123", e);
        }
        catch (Error e) {
            GUIExceptionHandler.showExceptionDialog(e);
        }
    }

    static {
        Thread.setDefaultUncaughtExceptionHandler(instance);
    }

    protected static class EventQueueProxy
    extends EventQueue
    implements Runnable {
        protected EventQueueProxy() {
        }

        @Override
        public void run() {
            EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
            queue.push(this);
        }

        @Override
        protected void dispatchEvent(AWTEvent newEvent) {
            try {
                super.dispatchEvent(newEvent);
            }
            catch (Throwable e) {
                StackTraceElement[] st;
                if (e instanceof ArrayIndexOutOfBoundsException && (st = e.getStackTrace()).length > 0 && "sun.font.FontDesignMetrics".equals(st[0].getClassName())) {
                    log.error("Ignored JRE bug exception " + e.getMessage() + " caused by : " + st[0]);
                    return;
                }
                GUIExceptionHandler.processException(Thread.currentThread(), e);
            }
        }
    }
}

