/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mobac.mapsources.mapspace.MercatorPower2MapSpace;
import mobac.program.interfaces.MapSpace;

public class MapDataFileParser {
    private static final String K = "[\\s ]*,[\\s ]*";
    private static final String HEAD_REGEX = "^OziExplorer Map Data File Version (\\d\\.\\d)";
    private static final String POINT_REGEX = "^Point(\\d\\d)@xy@(\\d+)@(\\d+)@in@deg@(\\d+)@(\\d+(?:\\.\\d+)?)@(N|S)@(\\d+)@(\\d+(?:\\.\\d+)?)@(E|W)@grid@@@.*";
    private static final String MMPLL_REGEX = "^MMPLL,(\\d)@(\\d+\\.\\d+)@(\\d+\\.\\d+)";

    public MapDataFileParser(File mapFile) throws IOException, MapFileFormatException {
        this(new FileInputStream(mapFile));
    }

    public MapDataFileParser(InputStream in) throws IOException, MapFileFormatException {
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        String line = br.readLine();
        Matcher m = Pattern.compile(HEAD_REGEX).matcher(line);
        if (!m.matches()) {
            throw new MapFileFormatException("OziExplorer Map Data File Version not found");
        }
        String fileVersion = m.group(1);
        line = br.readLine();
        Pattern pointP = Pattern.compile(POINT_REGEX.replaceAll("\\@", K));
        Pattern mmpllP = Pattern.compile(MMPLL_REGEX.replaceAll("\\@", K));
        ArrayList<MapPoint> mapPoints = new ArrayList<MapPoint>();
        while (line != null) {
            MapPoint p;
            String cLine = line;
            line = br.readLine();
            m = pointP.matcher(cLine);
            if (m.matches()) {
                p = new MapPoint();
                p.x = Integer.parseInt(m.group(2));
                p.y = Integer.parseInt(m.group(3));
                double lat = (double)Integer.parseInt(m.group(4)) + Double.parseDouble(m.group(5)) / 60.0;
                if ("S".equalsIgnoreCase(m.group(6))) {
                    lat = -lat;
                }
                p.lat = lat;
                double lon = (double)Integer.parseInt(m.group(7)) + Double.parseDouble(m.group(8)) / 60.0;
                if ("W".equalsIgnoreCase(m.group(9))) {
                    lon = -lon;
                }
                p.lon = lon;
                mapPoints.add(p);
                continue;
            }
            m = mmpllP.matcher(cLine);
            if (!m.matches()) continue;
            p = new MapPoint();
            p.lon = Double.parseDouble(m.group(2));
            p.lat = Double.parseDouble(m.group(3));
            mapPoints.add(p);
        }
        System.out.println("File version: " + fileVersion);
        double lat_max = Double.MIN_VALUE;
        double lon_max = Double.MIN_VALUE;
        double lat_min = Double.MAX_VALUE;
        double lon_min = Double.MAX_VALUE;
        for (MapPoint p : mapPoints) {
            lat_max = Math.max(lat_max, p.lat);
            lon_max = Math.max(lon_max, p.lon);
            lat_min = Math.min(lat_min, p.lat);
            lon_min = Math.min(lon_min, p.lon);
        }
        System.out.println(String.format("Max point (lat/lon): %4f %4f", lat_max, lon_max));
        System.out.println(String.format("Min point (lat/lon): %4f %4f", lat_min, lon_min));
        MapSpace ms = MercatorPower2MapSpace.INSTANCE_256;
        int x1 = ms.cLonToX(lon_max, 22);
        int x2 = ms.cLonToX(lon_min, 22);
        int diff = Math.abs(x1 - x2);
        for (int i = 1; i < 10; ++i) {
            System.out.println(22 - i + " : " + diff);
            diff /= 2;
        }
        br.close();
    }

    public static void main(String[] args) {
        try {
            File f = new File("atlases/Test_2009-10-01_164148/Test1/Test1 14/Test1 14.map");
            MapDataFileParser p = new MapDataFileParser(f);
            System.out.println(p);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class MapFileFormatException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MapFileFormatException(String message, Throwable cause) {
            super(message, cause);
        }

        public MapFileFormatException(String message) {
            super(message);
        }
    }

    public static class MapPoint {
        int x;
        int y;
        double lat;
        double lon;

        public String toString() {
            return String.format("%6f %6f", this.lat, this.lon);
        }
    }
}

