/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities;

public class MyMath {
    public static int roundDownToNearest(int value, int toNearest) {
        int remainder = value % toNearest;
        return value -= remainder;
    }

    public static int roundUpToNearest(int value, int toNearest) {
        int remainder = value % toNearest;
        if (remainder == 0) {
            return value;
        }
        return value += toNearest - remainder;
    }

    public static int ceil(double value) {
        return (int)Math.ceil(value);
    }

    public static int divCeil(int value, int divisor) {
        int result = value / divisor;
        int remainder = value % divisor;
        if (remainder != 0) {
            ++result;
        }
        return result;
    }

    public static long divCeil(long value, long divisor) {
        long result = value / divisor;
        if (value % divisor != 0L) {
            ++result;
        }
        return result;
    }

    public static int divRound(int value, int divisor) {
        int result = value / divisor;
        int remainder = value % divisor;
        if (remainder > divisor >> 1) {
            ++result;
        }
        return result;
    }

    public static long divRound(long value, long divisor) {
        long result = value / divisor;
        long remainder = value % divisor;
        if (remainder > divisor >> 1) {
            ++result;
        }
        return result;
    }

    public static double prettyRound(double val) {
        if (val < 1.0) {
            return Math.ceil(val);
        }
        int l10 = (int)Math.pow(10.0, Math.floor(Math.log10(val)));
        double x = val / (double)l10;
        x = Math.round(x);
        return x *= (double)l10;
    }
}

