/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.util.regex.Pattern;
import javax.naming.NameNotFoundException;
import javax.swing.JOptionPane;
import mobac.utilities.I18nUtils;
import org.apache.log4j.Logger;

public class OSUtilities {
    static Logger log = Logger.getLogger(OSUtilities.class);

    public static OperatingSystem detectOs() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") > -1) {
            return OperatingSystem.Windows;
        }
        if (osName.indexOf("linux") > -1) {
            return OperatingSystem.Linux;
        }
        if (osName.indexOf("mac os x") > -1) {
            return OperatingSystem.MacOsX;
        }
        if (osName.indexOf("mac os") > -1) {
            return OperatingSystem.MacOs;
        }
        if (osName.indexOf("sunos") > -1) {
            return OperatingSystem.Solaris;
        }
        return OperatingSystem.Unknown;
    }

    public static DesktopType detectDesktopType() {
        String desktopName = System.getProperty("sun.desktop");
        if (desktopName == null) {
            return DesktopType.Unknown;
        }
        if ((desktopName = desktopName.toLowerCase().trim()).startsWith("windows")) {
            return DesktopType.Windows;
        }
        if (desktopName.startsWith("gnome")) {
            return DesktopType.Gnome;
        }
        if (desktopName.startsWith("kde")) {
            return DesktopType.Kde;
        }
        log.error("Unknown desktop type: " + desktopName);
        return DesktopType.Unknown;
    }

    public static void openFolderBrowser(File directory) throws NameNotFoundException {
        if (!directory.isDirectory()) {
            throw new NameNotFoundException("Directory does not exist or is not a directory");
        }
        String[] strCmd = null;
        try {
            String dirPath = directory.getCanonicalPath();
            DesktopType dt = OSUtilities.detectDesktopType();
            block1 : switch (dt) {
                case Windows: {
                    strCmd = new String[]{"rundll32.exe", "url.dll,FileProtocolHandler", "\"" + dirPath + "\""};
                    break;
                }
                case Gnome: {
                    strCmd = new String[]{"nautilus", dirPath};
                    break;
                }
                case Kde: {
                    strCmd = new String[]{"konqueror", dirPath};
                    break;
                }
                default: {
                    String[] os = OSUtilities.detectOs();
                    switch (2.$SwitchMap$mobac$utilities$OSUtilities$OperatingSystem[os.ordinal()]) {
                        case 1: {
                            strCmd = new String[]{"/usr/bin/open", dirPath};
                            break block1;
                        }
                        case 2: {
                            strCmd = new String[]{"/usr/bin/xdg-open", dirPath};
                            break block1;
                        }
                    }
                    JOptionPane.showMessageDialog(null, String.format(I18nUtils.localizedStringForKey("msg_environment_not_support", new Object[0]), new Object[]{dt, os}), I18nUtils.localizedStringForKey("msg_environment_not_support_title", new Object[0]), 0);
                    return;
                }
            }
            for (String s : strCmd) {
                log.trace("exec/params: " + s);
            }
            Runtime.getRuntime().exec(strCmd);
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder(512);
            sb.append(I18nUtils.localizedStringForKey("msg_environment_failed_open_output", new Object[0]));
            sb.append(e.getMessage());
            sb.append(String.format(I18nUtils.localizedStringForKey("msg_environment_use_commond", new Object[0]), strCmd[0]));
            for (int i = 1; i < strCmd.length; ++i) {
                sb.append(String.format(I18nUtils.localizedStringForKey("msg_environment_commond_param", new Object[0]), i, strCmd[i]));
            }
            sb.append("</html>");
            String msg = sb.toString();
            JOptionPane.showMessageDialog(null, msg, I18nUtils.localizedStringForKey("msg_environment_failed_open_output_title", new Object[0]), 0);
            log.error(msg, e);
        }
    }

    public static String getLinuxDistributionName() {
        try {
            File etcDir = new File("/etc");
            if (!etcDir.exists()) {
                return null;
            }
            File[] files = etcDir.listFiles(new FilenameFilter(){
                Pattern pattern = Pattern.compile(".*-release");

                @Override
                public boolean accept(File dir2, String name) {
                    return this.pattern.matcher(name).matches();
                }
            });
            if (files.length == 0) {
                return null;
            }
            BufferedReader br = new BufferedReader(new FileReader(files[0]));
            String result = null;
            String line = null;
            line = br.readLine();
            while (line != null) {
                result = line;
                line = br.readLine();
            }
            br.close();
            if (result != null) {
                int index = result.indexOf(61);
                if (index > 0) {
                    result = result.substring(index + 1);
                }
                if (result.startsWith("\"") && result.endsWith("\"")) {
                    result = result.substring(1, result.length() - 2);
                }
            }
            return result;
        }
        catch (Exception e) {
            log.trace("", e);
            return null;
        }
    }

    public static boolean isPlatformOsx() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("mac os x");
    }

    public static enum DesktopType {
        Windows,
        Gnome,
        Kde,
        Unknown{

            public String toString() {
                return super.toString() + " (" + System.getProperty("sun.desktop") + ")";
            }
        };

    }

    public static enum OperatingSystem {
        Windows,
        Linux,
        MacOs,
        MacOsX,
        Solaris,
        Unknown;

    }
}

