/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.debug;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketImplFactory;
import java.net.URL;
import mobac.program.Logging;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class MySocketImplFactory
implements SocketImplFactory {
    private static Logger log = Logger.getLogger(MySocketImplFactory.class);
    private final Constructor<?> constructor;
    private final Method accept;
    private final Method bind;
    private final Method available;
    private final Method create;
    private final Method connect1;
    private final Method connect2;
    private final Method connect3;
    private final Method close;
    private final Method getInputStream;
    private final Method getOutputStream;
    private final Method sendUrgentData;
    private final Method listen;

    public static void main(String[] args) {
        try {
            MySocketImplFactory.install();
            Logging.configureConsoleLogging(Level.TRACE);
            HttpURLConnection conn = (HttpURLConnection)new URL("http://google.de").openConnection();
            conn.connect();
            byte[] data = new byte[1024];
            new DataInputStream(conn.getInputStream()).readFully(data);
            System.out.println(new String(data));
            Thread.sleep(1000L);
            System.gc();
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void install() throws IOException {
        try {
            Socket.setSocketImplFactory(new MySocketImplFactory());
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Unable to install " + MySocketImplFactory.class.getSimpleName(), e);
        }
    }

    public MySocketImplFactory() throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        Class<?> c = Class.forName("java.net.PlainSocketImpl");
        this.constructor = c.getDeclaredConstructor(new Class[0]);
        this.constructor.setAccessible(true);
        this.accept = c.getDeclaredMethod("accept", SocketImpl.class);
        this.accept.setAccessible(true);
        this.bind = c.getDeclaredMethod("bind", InetAddress.class, Integer.TYPE);
        this.bind.setAccessible(true);
        this.available = c.getDeclaredMethod("available", new Class[0]);
        this.available.setAccessible(true);
        this.create = c.getDeclaredMethod("create", Boolean.TYPE);
        this.create.setAccessible(true);
        this.connect1 = c.getDeclaredMethod("connect", InetAddress.class, Integer.TYPE);
        this.connect1.setAccessible(true);
        this.connect2 = c.getDeclaredMethod("connect", SocketAddress.class, Integer.TYPE);
        this.connect2.setAccessible(true);
        this.connect3 = c.getDeclaredMethod("connect", String.class, Integer.TYPE);
        this.connect3.setAccessible(true);
        this.getInputStream = c.getDeclaredMethod("getInputStream", new Class[0]);
        this.getInputStream.setAccessible(true);
        this.getOutputStream = c.getDeclaredMethod("getOutputStream", new Class[0]);
        this.getOutputStream.setAccessible(true);
        this.close = c.getDeclaredMethod("close", new Class[0]);
        this.close.setAccessible(true);
        this.sendUrgentData = c.getDeclaredMethod("sendUrgentData", Integer.TYPE);
        this.sendUrgentData.setAccessible(true);
        this.listen = c.getDeclaredMethod("listen", Integer.TYPE);
        this.listen.setAccessible(true);
    }

    @Override
    public SocketImpl createSocketImpl() {
        try {
            return new MySocketImpl();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class MySocketImpl
    extends SocketImpl {
        private final SocketImpl si;
        private final int socketId;

        private MySocketImpl() throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
            this.si = (SocketImpl)MySocketImplFactory.this.constructor.newInstance(new Object[0]);
            this.socketId = this.si.hashCode();
            log.trace("[" + this.socketId + "] new SocketImpl created");
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }

        @Override
        protected void accept(SocketImpl s) throws IOException {
            log.trace("[" + this.socketId + "] accept(...)");
            try {
                MySocketImplFactory.this.accept.invoke((Object)this.si, s);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        protected int available() throws IOException {
            try {
                return (Integer)MySocketImplFactory.this.bind.invoke((Object)this.si, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void bind(InetAddress host, int port) throws IOException {
            log.trace("[" + this.socketId + "] bind()");
            try {
                MySocketImplFactory.this.bind.invoke((Object)this.si, host, port);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void close() throws IOException {
            log.trace("[" + this.socketId + "] close()");
            try {
                MySocketImplFactory.this.close.invoke((Object)this.si, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void connect(InetAddress address, int port) throws IOException {
            log.trace("[" + this.socketId + "] connect1(..)");
            try {
                MySocketImplFactory.this.connect1.invoke((Object)this.si, address, port);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void connect(SocketAddress address, int timeout) throws IOException {
            log.trace("[" + this.socketId + "] connect2(..)");
            try {
                MySocketImplFactory.this.connect2.invoke((Object)this.si, address, timeout);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void connect(String host, int port) throws IOException {
            log.trace("[" + this.socketId + "] connect3(..)");
            try {
                MySocketImplFactory.this.connect3.invoke((Object)this.si, host, port);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void create(boolean stream) throws IOException {
            log.trace("[" + this.socketId + "] create(..)");
            try {
                MySocketImplFactory.this.create.invoke((Object)this.si, stream);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        protected InputStream getInputStream() throws IOException {
            try {
                return (InputStream)MySocketImplFactory.this.getInputStream.invoke((Object)this.si, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object getOption(int optID) throws SocketException {
            return this.si.getOption(optID);
        }

        @Override
        protected OutputStream getOutputStream() throws IOException {
            try {
                return (OutputStream)MySocketImplFactory.this.getOutputStream.invoke((Object)this.si, new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void listen(int backlog) throws IOException {
            log.trace("[" + this.socketId + "] listen(..)");
            try {
                MySocketImplFactory.this.listen.invoke((Object)this.si, backlog);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        protected void sendUrgentData(int data) throws IOException {
            try {
                MySocketImplFactory.this.sendUrgentData.invoke((Object)this.si, data);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setOption(int optID, Object value) throws SocketException {
            this.si.setOption(optID, value);
        }
    }
}

