/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.geo;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import mobac.utilities.geo.CoordinateDms2Format;
import org.apache.log4j.Logger;

public class CoordinateDm2Format
extends NumberFormat {
    protected static Logger log = Logger.getLogger(CoordinateDms2Format.class);
    NumberFormat degFmt;
    NumberFormat minFmt;
    NumberFormat minFmtParser;

    public CoordinateDm2Format(DecimalFormatSymbols dfs) {
        this.degFmt = new DecimalFormat("00\u00b0", dfs);
        this.minFmt = new DecimalFormat("00.00''", dfs);
        this.minFmt.setRoundingMode(RoundingMode.FLOOR);
        this.minFmtParser = new DecimalFormat("##.##", dfs);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        int degrees = number >= 0.0 ? (int)Math.floor(number) : (int)Math.ceil(number);
        double minutes = Math.abs((number - (double)degrees) * 60.0);
        if (number < 0.0 && degrees == 0) {
            toAppendTo.append("-");
        }
        toAppendTo.append(this.degFmt.format(degrees) + " ");
        toAppendTo.append(this.minFmt.format(minutes));
        return toAppendTo;
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public Number parse(String source) throws ParseException {
        return this.parse(source, new ParsePosition(0));
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        String[] tokens = source.trim().split("[\u00b0\\']");
        if (tokens.length != 2) {
            return null;
        }
        try {
            String degStr = tokens[0].trim();
            int deg = Integer.parseInt(degStr);
            double min = this.minFmtParser.parse(tokens[1].trim()).doubleValue();
            double coord = degStr.startsWith("-") ? (double)deg - min / 60.0 : (double)deg + min / 60.0;
            return new Double(coord);
        }
        catch (Exception e) {
            parsePosition.setErrorIndex(0);
            log.error("e");
            return null;
        }
    }
}

