/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.imageio;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import mobac.utilities.MyMath;
import mobac.utilities.imageio.PngChunk;
import mobac.utilities.imageio.PngConstants;

public class Png4BitWriter {
    public static void writeImage(File file, BufferedImage image) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            Png4BitWriter.writeImage(out, image);
        }
    }

    public static void writeImage(OutputStream out, BufferedImage image) throws IOException {
        Png4BitWriter.writeImage(out, image, 9);
    }

    public static void writeImage(OutputStream out, BufferedImage image, int compression) throws IOException {
        Png4BitWriter.writeImage(out, image, compression, null);
    }

    public static void writeImage(OutputStream out, BufferedImage image, int compression, String description) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        int width = image.getWidth();
        int height = image.getHeight();
        ColorModel cm = image.getColorModel();
        if (!(cm instanceof IndexColorModel)) {
            throw new UnsupportedOperationException("Image format not compatible");
        }
        IndexColorModel palette = (IndexColorModel)cm;
        dos.write(PngConstants.SIGNATURE);
        PngChunk cIHDR = new PngChunk(1229472850);
        cIHDR.writeInt(width);
        cIHDR.writeInt(height);
        cIHDR.writeByte(4);
        cIHDR.writeByte(3);
        cIHDR.writeByte(0);
        cIHDR.writeByte(0);
        cIHDR.writeByte(0);
        cIHDR.writeTo(dos);
        if (description != null) {
            PngChunk cTxT = new PngChunk(1950701684);
            cTxT.write("Description".getBytes());
            cTxT.write(0);
            cTxT.write(description.getBytes());
            cTxT.writeTo(dos);
        }
        PngChunk cPLTE = new PngChunk(1347179589);
        int paletteEntries = palette.getMapSize();
        byte[] r = new byte[paletteEntries];
        byte[] g = new byte[paletteEntries];
        byte[] b = new byte[paletteEntries];
        palette.getReds(r);
        palette.getGreens(g);
        palette.getBlues(b);
        int colorCount = Math.min(paletteEntries, 16);
        for (int i = 0; i < colorCount; ++i) {
            cPLTE.writeByte(r[i]);
            cPLTE.writeByte(g[i]);
            cPLTE.writeByte(b[i]);
        }
        cPLTE.writeTo(dos);
        PngChunk cIDAT = new PngChunk(1229209940);
        DeflaterOutputStream dfos = new DeflaterOutputStream((OutputStream)cIDAT, new Deflater(compression));
        int lineLen = MyMath.divCeil(width, 2);
        byte[] lineOut = new byte[lineLen];
        int[] samples = null;
        for (int line = 0; line < height; ++line) {
            dfos.write(0);
            samples = image.getRaster().getPixels(0, line, width, 1, samples);
            int sx = 0;
            int iMax = samples.length - 2;
            for (int i = 0; i < samples.length; i += 2) {
                int sample1 = samples[i];
                int sample2 = i <= iMax ? samples[i + 1] : 0;
                int s1 = sample1 & 0xF;
                int s2 = sample2 & 0xF;
                if (s1 != sample1 || s2 != sample2) {
                    throw new RuntimeException("sample has more than 4 bit!");
                }
                lineOut[sx++] = (byte)(s1 << 4 | s2);
            }
            dfos.write(lineOut);
        }
        dfos.finish();
        cIDAT.writeTo(dos);
        PngChunk cIEND = new PngChunk(1229278788);
        cIEND.writeTo(dos);
        cIEND.close();
        dos.flush();
    }

    protected static void writeColor(DataOutputStream dos, Color c) throws IOException {
        dos.writeByte(c.getRed());
        dos.writeByte(c.getGreen());
        dos.writeByte(c.getBlue());
    }
}

