/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.imageio;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.activation.UnsupportedDataTypeException;
import mobac.utilities.imageio.PngChunk;
import mobac.utilities.imageio.PngConstants;

public class PngXxlWriter {
    private static final int BUFFER_SIZE = 131072;
    private int width;
    private int height;
    private DataOutputStream dos;
    ImageDataChunkWriter imageDataChunkWriter;

    public PngXxlWriter(int width, int height, OutputStream os) throws IOException {
        this.width = width;
        this.height = height;
        this.dos = new DataOutputStream(os);
        this.dos.write(PngConstants.SIGNATURE);
        PngChunk cIHDR = new PngChunk(1229472850);
        cIHDR.writeInt(this.width);
        cIHDR.writeInt(this.height);
        cIHDR.writeByte(8);
        cIHDR.writeByte(2);
        cIHDR.writeByte(0);
        cIHDR.writeByte(0);
        cIHDR.writeByte(0);
        cIHDR.writeTo(this.dos);
        this.imageDataChunkWriter = new ImageDataChunkWriter(this.dos);
    }

    public void writeTileLine(BufferedImage tileLineImage) throws IOException {
        int tileLineHeight = tileLineImage.getHeight();
        int tileLineWidth = tileLineImage.getWidth();
        if (this.width != tileLineWidth) {
            throw new RuntimeException("Invalid width");
        }
        ColorModel cm = tileLineImage.getColorModel();
        if (!(cm instanceof DirectColorModel)) {
            throw new UnsupportedDataTypeException("Image uses wrong color model. Only DirectColorModel is supported!");
        }
        Rectangle rect = new Rectangle(0, 0, tileLineWidth, 1);
        DataOutputStream imageDataStream = this.imageDataChunkWriter.getStream();
        byte[] curLine = new byte[this.width * 3];
        for (int line = 0; line < tileLineHeight; ++line) {
            rect.y = line;
            DataBuffer db = tileLineImage.getData(rect).getDataBuffer();
            if (db.getNumBanks() > 1) {
                throw new UnsupportedDataTypeException("Image data has more than one data bank");
            }
            if (db instanceof DataBufferByte) {
                curLine = ((DataBufferByte)db).getData();
            } else if (db instanceof DataBufferInt) {
                int[] intLine = ((DataBufferInt)db).getData();
                int c = 0;
                for (int i = 0; i < intLine.length; ++i) {
                    int pixel = intLine[i];
                    curLine[c++] = (byte)(pixel >> 16 & 0xFF);
                    curLine[c++] = (byte)(pixel >> 8 & 0xFF);
                    curLine[c++] = (byte)(pixel & 0xFF);
                }
            } else {
                throw new UnsupportedDataTypeException(db.getClass().getName());
            }
            imageDataStream.write(0);
            imageDataStream.write(curLine);
        }
    }

    public void finish() throws IOException {
        this.imageDataChunkWriter.finish();
        PngChunk cIEND = new PngChunk(1229278788);
        cIEND.writeTo(this.dos);
        cIEND.close();
        this.dos.flush();
    }

    static class ImageDataChunkWriter
    extends OutputStream {
        DeflaterOutputStream dfos;
        DataOutputStream stream;
        DataOutputStream out;
        CRC32 crc = new CRC32();

        public ImageDataChunkWriter(DataOutputStream out) throws IOException {
            this.out = out;
            this.dfos = new DeflaterOutputStream((OutputStream)new BufferedOutputStream(this, 131072), new Deflater(9));
            this.stream = new DataOutputStream(this.dfos);
        }

        public DataOutputStream getStream() {
            return this.stream;
        }

        public void finish() throws IOException {
            this.stream.flush();
            this.stream.close();
            this.dfos.finish();
            this.dfos = null;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.crc.reset();
            this.out.writeInt(len);
            this.out.writeInt(1229209940);
            this.out.write(b, off, len);
            this.crc.update("IDAT".getBytes());
            this.crc.update(b, off, len);
            this.out.writeInt((int)this.crc.getValue());
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(int b) throws IOException {
            throw new IOException("Simgle byte writing not supported");
        }
    }
}

