/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class DriverProxy
implements Driver {
    private static org.apache.log4j.Logger log = org.apache.log4j.Logger.getLogger(DriverProxy.class);
    private final Driver driver;

    public DriverProxy(String className, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class<?> c = classLoader.loadClass(className);
        this.driver = (Driver)c.newInstance();
        log.info("SQL driver loaded: v" + this.driver.getMajorVersion() + "." + this.driver.getMinorVersion() + " [" + this.driver.getClass().getName() + "]");
    }

    public static void loadSQLDriver(String className, ClassLoader classLoader) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SQLException {
        DriverProxy driver = new DriverProxy(className, classLoader);
        DriverManager.registerDriver(driver);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return this.driver.acceptsURL(url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.driver.connect(url, info);
    }

    @Override
    public int getMajorVersion() {
        return this.driver.getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.driver.getMinorVersion();
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.driver.getPropertyInfo(url, info);
    }

    @Override
    public boolean jdbcCompliant() {
        return this.driver.jdbcCompliant();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

