/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.stream;

import java.io.IOException;
import java.io.OutputStream;

public class ArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int pos = 0;

    public ArrayOutputStream(int size) {
        this.buf = new byte[size];
    }

    public ArrayOutputStream(byte[] array) {
        this.buf = array;
    }

    public ArrayOutputStream(byte[] array, int off) {
        this.buf = array;
        this.pos = off;
    }

    public byte[] toByteArray() {
        byte[] data = new byte[this.pos];
        System.arraycopy(this.buf, 0, data, 0, this.pos);
        return data;
    }

    public void reset() {
        this.pos = 0;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int newPos = this.pos + len;
        if (newPos > this.buf.length) {
            throw new IOException("End of buffer reached");
        }
        System.arraycopy(b, off, this.buf, this.pos, len);
        this.pos = newPos;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }
}

