/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.stream;

import org.apache.log4j.Logger;

public class ThrottleSupport {
    public static final long TICK_LENGTH = 512L;
    private static Logger logger = Logger.getLogger(ThrottleSupport.class);
    protected long bandwidth = 0L;
    protected long allocated = 0L;
    protected long tick = 0L;
    protected Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBandwidth(long bandwidth) {
        Object object = this.lock;
        synchronized (object) {
            this.bandwidth = bandwidth * 512L / 1024L;
        }
    }

    public int allocate(int bytes) {
        if (bytes == 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                long t;
                do {
                    if (this.bandwidth == 0L) {
                        return bytes;
                    }
                    long currentTick = System.currentTimeMillis() >> 9;
                    if (currentTick > this.tick) {
                        logger.debug("* new tick: " + this.bandwidth + " to allocate *");
                        this.tick = currentTick;
                        this.allocated = 0L;
                        this.lock.notifyAll();
                    }
                    if ((long)bytes < this.bandwidth - this.allocated) {
                        this.allocated += (long)bytes;
                        logger.debug("returning " + bytes + " allocated now " + this.allocated);
                        return bytes;
                    }
                    if (this.bandwidth - this.allocated <= 0L) continue;
                    bytes = (int)(this.bandwidth - this.allocated);
                    this.allocated = this.bandwidth;
                    logger.debug("returning " + bytes + " allocated now " + this.allocated);
                    return bytes;
                } while ((t = 512L - System.currentTimeMillis() % 512L) <= 0L);
                try {
                    logger.debug("waiting for " + t);
                    this.lock.wait(t);
                }
                catch (InterruptedException e) {
                    return -1;
                }
            }
        }
    }
}

