/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.tar;

import java.io.File;
import java.io.UnsupportedEncodingException;

public class TarHeader {
    private File baseFilePath;
    private int fileNameLength;
    private final char[] fileName = new char[100];
    private final char[] fileMode = new char[8];
    private final char[] fileOwnerUserID = new char[8];
    private final char[] fileOwnerGroupID = new char[8];
    private final char[] fileSize = new char[12];
    private final char[] lastModificationTime = new char[12];
    private final char[] linkIndicator = new char[1];
    private final char[] nameOfLinkedFile = new char[100];
    private static final char[] padding = new char[255];

    public TarHeader() {
    }

    public TarHeader(File theFile, File theBaseFilePath) {
        this();
        this.baseFilePath = theBaseFilePath;
        this.setFileName(theFile, this.baseFilePath);
        this.setFileMode();
        this.setFileOwnerUserID();
        this.setFileOwnerGroupID();
        this.setFileSize(theFile);
        this.setLastModificationTime(theFile);
        this.setLinkIndicator(theFile);
    }

    public TarHeader(String fileName, int fileSize, boolean isDirectory) {
        this();
        this.setFileName(fileName);
        this.setFileMode();
        this.setFileOwnerUserID();
        this.setFileOwnerGroupID();
        this.setFileSize(fileSize);
        this.setLastModificationTime(System.currentTimeMillis());
        this.setLinkIndicator(isDirectory);
    }

    public void read(byte[] buffer) {
        String fn = new String(buffer, 0, 512);
        fn.getChars(0, 100, this.fileName, 0);
        this.fileNameLength = fn.indexOf(0);
        fn.getChars(100, 108, this.fileMode, 0);
        fn.getChars(108, 116, this.fileOwnerUserID, 0);
        fn.getChars(116, 124, this.fileOwnerGroupID, 0);
        fn.getChars(124, 136, this.fileSize, 0);
        fn.getChars(136, 148, this.lastModificationTime, 0);
        fn.getChars(156, 157, this.linkIndicator, 0);
        fn.getChars(157, 257, this.nameOfLinkedFile, 0);
    }

    public void setFileName(File theFile, File theBaseFilePath) {
        String basePath;
        String filePath = theFile.getAbsolutePath();
        if (!filePath.startsWith(basePath = theBaseFilePath.getAbsolutePath())) {
            throw new RuntimeException("File \"" + filePath + "\" is outside of archive base path \"" + basePath + "\"!");
        }
        String tarFileName = filePath.substring(basePath.length(), filePath.length());
        if ((tarFileName = tarFileName.replace('\\', '/')).startsWith("/")) {
            tarFileName = tarFileName.substring(1, tarFileName.length());
        }
        if (theFile.isDirectory()) {
            tarFileName = tarFileName + "/";
        }
        this.setFileName(tarFileName);
    }

    public void setFileName(String newFileName) {
        int newFileNameLength = newFileName.length();
        if (newFileNameLength > this.fileName.length) {
            throw new RuntimeException("File name length exceeds limit of 100 characters: " + newFileNameLength + "chars:" + newFileName);
        }
        char[] theFileName = newFileName.toCharArray();
        System.arraycopy(theFileName, 0, this.fileName, 0, newFileNameLength);
        this.fileNameLength = newFileNameLength;
        for (int i = newFileNameLength; i < this.fileName.length; ++i) {
            this.fileName[i] = '\u0000';
        }
    }

    public void setFileMode() {
        "   777 ".getChars(0, 7, this.fileMode, 0);
    }

    public void setFileOwnerUserID() {
        "     0  ".getChars(0, 7, this.fileOwnerUserID, 0);
    }

    public void setFileOwnerGroupID() {
        "     0  ".getChars(0, 7, this.fileOwnerGroupID, 0);
    }

    public void setFileSize(File theFile) {
        long fileSizeLong = 0L;
        if (!theFile.isDirectory()) {
            fileSizeLong = theFile.length();
        }
        this.setFileSize(fileSizeLong);
    }

    public void setFileSize(long fileSize) {
        char[] fileSizeCharArray = Long.toString(fileSize, 8).toCharArray();
        int offset = 11 - fileSizeCharArray.length;
        for (int i = 0; i < 12; ++i) {
            this.fileSize[i] = i < offset ? 32 : (i == 11 ? 32 : fileSizeCharArray[i - offset]);
        }
    }

    public void setLastModificationTime(File theFile) {
        this.setLastModificationTime(theFile.lastModified());
    }

    public void setLastModificationTime(long lastModifiedTime) {
        int i;
        char[] fileLastModifiedTimeCharArray = Long.toString(lastModifiedTime /= 1000L, 8).toCharArray();
        for (i = 0; i < fileLastModifiedTimeCharArray.length; ++i) {
            this.lastModificationTime[i] = fileLastModifiedTimeCharArray[i];
        }
        if (fileLastModifiedTimeCharArray.length < 12) {
            for (i = fileLastModifiedTimeCharArray.length; i < 12; ++i) {
                this.lastModificationTime[i] = 32;
            }
        }
    }

    public void setLinkIndicator(File theFile) {
        this.setLinkIndicator(theFile.isDirectory());
    }

    public void setLinkIndicator(boolean isDirectory) {
        this.linkIndicator[0] = isDirectory ? 53 : 48;
    }

    public String getFileName() {
        return new String(this.fileName, 0, this.fileNameLength);
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public char[] getFileMode() {
        return this.fileMode;
    }

    public char[] getFileOwnerUserID() {
        return this.fileOwnerUserID;
    }

    public char[] getFileOwnerGroupID() {
        return this.fileOwnerGroupID;
    }

    public char[] getFileSize() {
        return this.fileSize;
    }

    public int getFileSizeInt() {
        return Integer.parseInt(new String(this.fileSize).trim(), 8);
    }

    public char[] getLastModificationTime() {
        return this.lastModificationTime;
    }

    public char[] getLinkIndicator() {
        return this.linkIndicator;
    }

    public char[] getNameOfLinkedFile() {
        return this.nameOfLinkedFile;
    }

    public char[] getPadding() {
        return padding;
    }

    public void correctCheckSum(byte[] header) {
        int checksum = 0;
        for (int i = 0; i < 512; ++i) {
            checksum += header[i] & 0xFF;
        }
        String s = Integer.toOctalString(checksum);
        while (s.length() < 6) {
            s = '0' + s;
        }
        byte[] checksumBin = s.getBytes();
        System.arraycopy(checksumBin, 0, header, 148, 6);
        header[154] = 0;
    }

    public byte[] getBytes() {
        byte[] result;
        StringBuffer sb = new StringBuffer(512);
        sb.append(this.fileName);
        sb.append(this.fileMode);
        sb.append(this.fileOwnerUserID);
        sb.append(this.fileOwnerGroupID);
        sb.append(this.fileSize);
        sb.append(this.lastModificationTime);
        sb.append("        ");
        sb.append(this.linkIndicator);
        sb.append(this.nameOfLinkedFile);
        sb.append(padding);
        try {
            result = sb.toString().getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (result.length != 512) {
            throw new RuntimeException("Invalid tar header size: " + result.length);
        }
        this.correctCheckSum(result);
        return result;
    }
}

