/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.tar;

import java.util.Hashtable;

public class TarIndexTable {
    private Hashtable<String, Integer> hashTable;

    public TarIndexTable(int initialCapacity) {
        this.hashTable = new Hashtable(initialCapacity);
    }

    public void addTarEntry(String filename, long streamPos) {
        assert ((streamPos & 0x1FL) == 0L);
        int tarBlockIndex = (int)(streamPos >> 9);
        this.hashTable.put(filename, new Integer(tarBlockIndex));
    }

    public long getEntryOffset(String filename) {
        Integer tarBlockIndex = this.hashTable.get(filename);
        if (tarBlockIndex == null) {
            return -1L;
        }
        long offset = (long)tarBlockIndex.intValue() << 9;
        return offset;
    }

    public int size() {
        return this.hashTable.size();
    }
}

