/*
 * Decompiled with CFR 0.152.
 */
package mobac.utilities.tar;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import mobac.utilities.Utilities;

public class TarRecord {
    private byte[] fileData;

    public TarRecord(File theFile) throws IOException {
        this.fileData = new byte[TarRecord.calculateFileSizeInTar(theFile)];
        this.setRecordContent(theFile);
    }

    public TarRecord(byte[] data) throws IOException {
        this(data, 0, data.length);
    }

    public TarRecord(byte[] data, int off, int len) throws IOException {
        this.fileData = new byte[TarRecord.calculateFileSizeInTar(len)];
        System.arraycopy(data, off, this.fileData, 0, len);
    }

    public static int calculateFileSizeInTar(File theFile) {
        long fl = theFile.length();
        if (fl > Integer.MAX_VALUE) {
            throw new RuntimeException("File size too large");
        }
        return TarRecord.calculateFileSizeInTar((int)fl);
    }

    public static int calculateFileSizeInTar(int fileLength) {
        if (fileLength < 512) {
            return 512;
        }
        int mod = fileLength % 512;
        if (mod != 0) {
            fileLength += 512 - mod;
        }
        return fileLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecordContent(File theFile) throws IOException {
        FileInputStream inputFile = null;
        try {
            inputFile = new FileInputStream(theFile);
            DataInputStream dIn = new DataInputStream(inputFile);
            dIn.readFully(this.fileData, 0, (int)theFile.length());
            dIn.close();
        }
        catch (Throwable throwable) {
            Utilities.closeStream(inputFile);
            throw throwable;
        }
        Utilities.closeStream(inputFile);
    }

    public byte[] getRecordContent() {
        return this.fileData;
    }
}

