/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.mapelements;

import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;

public class WayTextContainer
extends MapElementContainer {
    private final Paint paintFront;
    private final Paint paintBack;
    private final String text;
    private final Point end;

    public WayTextContainer(Point point, Point end, Display display, int priority, String text, Paint paintFront, Paint paintBack, double textHeight) {
        super(point, display, priority);
        this.text = text;
        this.paintFront = paintFront;
        this.paintBack = paintBack;
        this.end = end;
        this.boundary = null;
        this.boundaryAbsolute = new Rectangle(Math.min(point.x, end.x), Math.min(point.y, end.y), Math.max(point.x, end.x), Math.max(point.y, end.y)).envelope(textHeight / 2.0);
    }

    @Override
    public void draw(Canvas canvas, Point origin, Matrix matrix) {
        Point adjustedStart = this.xy.offset(-origin.x, -origin.y);
        Point adjustedEnd = this.end.offset(-origin.x, -origin.y);
        if (this.paintBack != null) {
            canvas.drawTextRotated(this.text, (int)adjustedStart.x, (int)adjustedStart.y, (int)adjustedEnd.x, (int)adjustedEnd.y, this.paintBack);
        }
        canvas.drawTextRotated(this.text, (int)adjustedStart.x, (int)adjustedStart.y, (int)adjustedEnd.x, (int)adjustedEnd.y, this.paintFront);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append(", text=");
        stringBuilder.append(this.text);
        return stringBuilder.toString();
    }
}

