/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.model;

import java.io.Serializable;
import org.mapsforge.core.util.LatLongUtils;

public class LatLong
implements Comparable<LatLong>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final double latitude;
    public final double longitude;

    public LatLong(double latitude, double longitude, boolean validate) {
        if (validate) {
            LatLongUtils.validateLatitude(latitude);
            LatLongUtils.validateLongitude(longitude);
        }
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public LatLong(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
    }

    @Override
    public int compareTo(LatLong latLong) {
        if (this.longitude > latLong.longitude) {
            return 1;
        }
        if (this.longitude < latLong.longitude) {
            return -1;
        }
        if (this.latitude > latLong.latitude) {
            return 1;
        }
        if (this.latitude < latLong.latitude) {
            return -1;
        }
        return 0;
    }

    public double distance(LatLong other) {
        return Math.hypot(this.longitude - other.longitude, this.latitude - other.latitude);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LatLong)) {
            return false;
        }
        LatLong other = (LatLong)obj;
        if (Double.doubleToLongBits(this.latitude) != Double.doubleToLongBits(other.latitude)) {
            return false;
        }
        return Double.doubleToLongBits(this.longitude) == Double.doubleToLongBits(other.longitude);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.latitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.longitude);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("latitude=");
        stringBuilder.append(this.latitude);
        stringBuilder.append(", longitude=");
        stringBuilder.append(this.longitude);
        return stringBuilder.toString();
    }
}

