/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.model;

import java.io.Serializable;
import org.mapsforge.core.model.Point;

public class Rectangle
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final double bottom;
    public final double left;
    public final double right;
    public final double top;

    public Rectangle(double left, double top, double right, double bottom) {
        if (left > right) {
            throw new IllegalArgumentException("left: " + left + ", right: " + right);
        }
        if (top > bottom) {
            throw new IllegalArgumentException("top: " + top + ", bottom: " + bottom);
        }
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }

    public boolean contains(Point point) {
        return this.left <= point.x && this.right >= point.x && this.top <= point.y && this.bottom >= point.y;
    }

    public Rectangle envelope(double padding) {
        return new Rectangle(this.left - padding, this.top - padding, this.right + padding, this.bottom + padding);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Rectangle)) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        if (Double.doubleToLongBits(this.left) != Double.doubleToLongBits(other.left)) {
            return false;
        }
        if (Double.doubleToLongBits(this.top) != Double.doubleToLongBits(other.top)) {
            return false;
        }
        if (Double.doubleToLongBits(this.right) != Double.doubleToLongBits(other.right)) {
            return false;
        }
        return Double.doubleToLongBits(this.bottom) == Double.doubleToLongBits(other.bottom);
    }

    public Point getCenter() {
        return new Point(this.getCenterX(), this.getCenterY());
    }

    public double getCenterX() {
        return (this.left + this.right) / 2.0;
    }

    public double getCenterY() {
        return (this.top + this.bottom) / 2.0;
    }

    public double getHeight() {
        return this.bottom - this.top;
    }

    public double getWidth() {
        return this.right - this.left;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.left);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.top);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.right);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.bottom);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean intersects(Rectangle rectangle) {
        if (this == rectangle) {
            return true;
        }
        return this.left <= rectangle.right && rectangle.left <= this.right && this.top <= rectangle.bottom && rectangle.top <= this.bottom;
    }

    public boolean intersectsCircle(double pointX, double pointY, double radius) {
        double halfWidth = this.getWidth() / 2.0;
        double halfHeight = this.getHeight() / 2.0;
        double centerDistanceX = Math.abs(pointX - this.getCenterX());
        double centerDistanceY = Math.abs(pointY - this.getCenterY());
        if (centerDistanceX > halfWidth + radius) {
            return false;
        }
        if (centerDistanceY > halfHeight + radius) {
            return false;
        }
        if (centerDistanceX <= halfWidth) {
            return true;
        }
        if (centerDistanceY <= halfHeight) {
            return true;
        }
        double cornerDistanceX = centerDistanceX - halfWidth;
        double cornerDistanceY = centerDistanceY - halfHeight;
        return cornerDistanceX * cornerDistanceX + cornerDistanceY * cornerDistanceY <= radius * radius;
    }

    public Rectangle shift(Point origin) {
        if (origin.x == 0.0 && origin.y == 0.0) {
            return this;
        }
        return new Rectangle(this.left + origin.x, this.top + origin.y, this.right + origin.x, this.bottom + origin.y);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("left=");
        stringBuilder.append(this.left);
        stringBuilder.append(", top=");
        stringBuilder.append(this.top);
        stringBuilder.append(", right=");
        stringBuilder.append(this.right);
        stringBuilder.append(", bottom=");
        stringBuilder.append(this.bottom);
        return stringBuilder.toString();
    }
}

