/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.util.MercatorProjection;

public class Tile
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final long mapSize;
    public final int tileSize;
    public final int tileX;
    public final int tileY;
    public final byte zoomLevel;
    private BoundingBox boundingBox;
    private Point origin;

    public static int getMaxTileNumber(byte zoomLevel) {
        if (zoomLevel < 0) {
            throw new IllegalArgumentException("zoomLevel must not be negative: " + zoomLevel);
        }
        if (zoomLevel == 0) {
            return 0;
        }
        return (2 << zoomLevel - 1) - 1;
    }

    public Tile(int tileX, int tileY, byte zoomLevel, int tileSize) {
        if (tileX < 0) {
            throw new IllegalArgumentException("tileX must not be negative: " + tileX);
        }
        if (tileY < 0) {
            throw new IllegalArgumentException("tileY must not be negative: " + tileY);
        }
        if (zoomLevel < 0) {
            throw new IllegalArgumentException("zoomLevel must not be negative: " + zoomLevel);
        }
        long maxTileNumber = Tile.getMaxTileNumber(zoomLevel);
        if ((long)tileX > maxTileNumber) {
            throw new IllegalArgumentException("invalid tileX number on zoom level " + zoomLevel + ": " + tileX);
        }
        if ((long)tileY > maxTileNumber) {
            throw new IllegalArgumentException("invalid tileY number on zoom level " + zoomLevel + ": " + tileY);
        }
        this.tileSize = tileSize;
        this.tileX = tileX;
        this.tileY = tileY;
        this.zoomLevel = zoomLevel;
        this.mapSize = MercatorProjection.getMapSize(zoomLevel, tileSize);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Tile)) {
            return false;
        }
        Tile other = (Tile)obj;
        if (this.tileX != other.tileX) {
            return false;
        }
        if (this.tileY != other.tileY) {
            return false;
        }
        if (this.zoomLevel != other.zoomLevel) {
            return false;
        }
        return this.tileSize == other.tileSize;
    }

    public BoundingBox getBoundingBox() {
        if (this.boundingBox == null) {
            double minLatitude = Math.max(-85.05112877980659, MercatorProjection.tileYToLatitude((long)(this.tileY + 1), this.zoomLevel));
            double minLongitude = Math.max(-180.0, MercatorProjection.tileXToLongitude((long)this.tileX, this.zoomLevel));
            double maxLatitude = Math.min(85.05112877980659, MercatorProjection.tileYToLatitude((long)this.tileY, this.zoomLevel));
            double maxLongitude = Math.min(180.0, MercatorProjection.tileXToLongitude((long)(this.tileX + 1), this.zoomLevel));
            if (maxLongitude == -180.0) {
                maxLongitude = 180.0;
            }
            this.boundingBox = new BoundingBox(minLatitude, minLongitude, maxLatitude, maxLongitude);
        }
        return this.boundingBox;
    }

    public Set<Tile> getNeighbours() {
        HashSet<Tile> neighbours = new HashSet<Tile>(8);
        neighbours.add(this.getLeft());
        neighbours.add(this.getAboveLeft());
        neighbours.add(this.getAbove());
        neighbours.add(this.getAboveRight());
        neighbours.add(this.getRight());
        neighbours.add(this.getBelowRight());
        neighbours.add(this.getBelow());
        neighbours.add(this.getBelowLeft());
        return neighbours;
    }

    public Rectangle getBoundaryAbsolute() {
        return new Rectangle(this.getOrigin().x, this.getOrigin().y, this.getOrigin().x + (double)this.tileSize, this.getOrigin().y + (double)this.tileSize);
    }

    public Rectangle getBoundaryRelative() {
        return new Rectangle(0.0, 0.0, this.tileSize, this.tileSize);
    }

    public Point getOrigin() {
        if (this.origin == null) {
            double x = MercatorProjection.tileToPixel(this.tileX, this.tileSize);
            double y = MercatorProjection.tileToPixel(this.tileY, this.tileSize);
            this.origin = new Point(x, y);
        }
        return this.origin;
    }

    public Tile getLeft() {
        int x = this.tileX - 1;
        if (x < 0) {
            x = Tile.getMaxTileNumber(this.zoomLevel);
        }
        return new Tile(x, this.tileY, this.zoomLevel, this.tileSize);
    }

    public Tile getRight() {
        int x = this.tileX + 1;
        if (x > Tile.getMaxTileNumber(this.zoomLevel)) {
            x = 0;
        }
        return new Tile(x, this.tileY, this.zoomLevel, this.tileSize);
    }

    public Tile getAbove() {
        int y = this.tileY - 1;
        if (y < 0) {
            y = Tile.getMaxTileNumber(this.zoomLevel);
        }
        return new Tile(this.tileX, y, this.zoomLevel, this.tileSize);
    }

    public Tile getBelow() {
        int y = this.tileY + 1;
        if (y > Tile.getMaxTileNumber(this.zoomLevel)) {
            y = 0;
        }
        return new Tile(this.tileX, y, this.zoomLevel, this.tileSize);
    }

    public Tile getAboveLeft() {
        int y = this.tileY - 1;
        int x = this.tileX - 1;
        if (y < 0) {
            y = Tile.getMaxTileNumber(this.zoomLevel);
        }
        if (x < 0) {
            x = Tile.getMaxTileNumber(this.zoomLevel);
        }
        return new Tile(x, y, this.zoomLevel, this.tileSize);
    }

    public Tile getAboveRight() {
        int y = this.tileY - 1;
        int x = this.tileX + 1;
        if (y < 0) {
            y = Tile.getMaxTileNumber(this.zoomLevel);
        }
        if (x > Tile.getMaxTileNumber(this.zoomLevel)) {
            x = 0;
        }
        return new Tile(x, y, this.zoomLevel, this.tileSize);
    }

    public Tile getBelowLeft() {
        int y = this.tileY + 1;
        int x = this.tileX - 1;
        if (y > Tile.getMaxTileNumber(this.zoomLevel)) {
            y = 0;
        }
        if (x < 0) {
            x = Tile.getMaxTileNumber(this.zoomLevel);
        }
        return new Tile(x, y, this.zoomLevel, this.tileSize);
    }

    public Tile getBelowRight() {
        int y = this.tileY + 1;
        int x = this.tileX + 1;
        if (y > Tile.getMaxTileNumber(this.zoomLevel)) {
            y = 0;
        }
        if (x > Tile.getMaxTileNumber(this.zoomLevel)) {
            x = 0;
        }
        return new Tile(x, y, this.zoomLevel, this.tileSize);
    }

    public Tile getParent() {
        if (this.zoomLevel == 0) {
            return null;
        }
        return new Tile(this.tileX / 2, this.tileY / 2, (byte)(this.zoomLevel - 1), this.tileSize);
    }

    public int getShiftX(Tile otherTile) {
        if (this.equals(otherTile)) {
            return 0;
        }
        return this.tileX % 2 + 2 * this.getParent().getShiftX(otherTile);
    }

    public int getShiftY(Tile otherTile) {
        if (this.equals(otherTile)) {
            return 0;
        }
        return this.tileY % 2 + 2 * this.getParent().getShiftY(otherTile);
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + (this.tileX ^ this.tileX >>> 16);
        result = 31 * result + (this.tileY ^ this.tileY >>> 16);
        result = 31 * result + this.zoomLevel;
        result = 31 * result + this.tileSize;
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("x=");
        stringBuilder.append(this.tileX);
        stringBuilder.append(", y=");
        stringBuilder.append(this.tileY);
        stringBuilder.append(", z=");
        stringBuilder.append(this.zoomLevel);
        return stringBuilder.toString();
    }
}

