/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.util.MercatorProjection;

public final class LatLongUtils {
    public static final double EQUATORIAL_RADIUS = 6378137.0;
    public static final double LATITUDE_MAX = 90.0;
    public static final double LATITUDE_MIN = -90.0;
    public static final double LONGITUDE_MAX = 180.0;
    public static final double LONGITUDE_MIN = -180.0;
    private static final double CONVERSION_FACTOR = 1000000.0;
    private static final String DELIMITER = ",";

    public static int degreesToMicrodegrees(double coordinate) {
        return (int)(coordinate * 1000000.0);
    }

    public static LatLong fromString(String latLongString) {
        double[] coordinates = LatLongUtils.parseCoordinateString(latLongString, 2);
        return new LatLong(coordinates[0], coordinates[1], true);
    }

    public static double latitudeDistance(int meters) {
        return (double)(meters * 360) / 4.007501668557849E7;
    }

    public static double longitudeDistance(int meters, double latitude) {
        return (double)(meters * 360) / (4.007501668557849E7 * Math.cos(Math.toRadians(latitude)));
    }

    public static double microdegreesToDegrees(int coordinate) {
        return (double)coordinate / 1000000.0;
    }

    public static double[] parseCoordinateString(String coordinatesString, int numberOfCoordinates) {
        StringTokenizer stringTokenizer = new StringTokenizer(coordinatesString, DELIMITER, true);
        boolean isDelimiter = true;
        ArrayList<String> tokens = new ArrayList<String>(numberOfCoordinates);
        while (stringTokenizer.hasMoreTokens()) {
            String token = stringTokenizer.nextToken();
            boolean bl = isDelimiter = !isDelimiter;
            if (isDelimiter) continue;
            tokens.add(token);
        }
        if (isDelimiter) {
            throw new IllegalArgumentException("invalid coordinate delimiter: " + coordinatesString);
        }
        if (tokens.size() != numberOfCoordinates) {
            throw new IllegalArgumentException("invalid number of coordinate values: " + coordinatesString);
        }
        double[] coordinates = new double[numberOfCoordinates];
        for (int i = 0; i < numberOfCoordinates; ++i) {
            coordinates[i] = Double.parseDouble((String)tokens.get(i));
        }
        return coordinates;
    }

    public static void validateLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("invalid latitude: " + latitude);
        }
    }

    public static void validateLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("invalid longitude: " + longitude);
        }
    }

    public static byte zoomForBounds(Dimension dimension, BoundingBox boundingBox, int tileSize) {
        double pixelYMin;
        double pixelYMax;
        double zoomY;
        double pixelXMin;
        long mapSize = MercatorProjection.getMapSize((byte)0, tileSize);
        double pixelXMax = MercatorProjection.longitudeToPixelX(boundingBox.maxLongitude, mapSize);
        double zoomX = -Math.log(Math.abs(pixelXMax - (pixelXMin = MercatorProjection.longitudeToPixelX(boundingBox.minLongitude, mapSize))) / (double)dimension.width) / Math.log(2.0);
        double zoom = Math.floor(Math.min(zoomX, zoomY = -Math.log(Math.abs((pixelYMax = MercatorProjection.latitudeToPixelY(boundingBox.maxLatitude, mapSize)) - (pixelYMin = MercatorProjection.latitudeToPixelY(boundingBox.minLatitude, mapSize))) / (double)dimension.height) / Math.log(2.0)));
        if (zoom < 0.0) {
            return 0;
        }
        if (zoom > 127.0) {
            return 127;
        }
        return (byte)zoom;
    }

    private LatLongUtils() {
        throw new IllegalStateException();
    }
}

