/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.core.util;

import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Tile;

public final class MercatorProjection {
    public static final double EARTH_CIRCUMFERENCE = 4.0075016686E7;
    public static final double LATITUDE_MAX = 85.05112877980659;
    public static final double LATITUDE_MIN = -85.05112877980659;
    private static final int DUMMY_TILE_SIZE = 256;

    public static double calculateGroundResolutionWithScaleFactor(double latitude, double scaleFactor, int tileSize) {
        long mapSize = MercatorProjection.getMapSizeWithScaleFactor(scaleFactor, tileSize);
        return Math.cos(latitude * (Math.PI / 180)) * 4.0075016686E7 / (double)mapSize;
    }

    public static double calculateGroundResolution(double latitude, long mapSize) {
        return Math.cos(latitude * (Math.PI / 180)) * 4.0075016686E7 / (double)mapSize;
    }

    public static LatLong fromPixelsWithScaleFactor(double pixelX, double pixelY, double scaleFactor, int tileSize) {
        return new LatLong(MercatorProjection.pixelYToLatitudeWithScaleFactor(pixelY, scaleFactor, tileSize), MercatorProjection.pixelXToLongitudeWithScaleFactor(pixelX, scaleFactor, tileSize));
    }

    public static LatLong fromPixels(double pixelX, double pixelY, long mapSize) {
        return new LatLong(MercatorProjection.pixelYToLatitude(pixelY, mapSize), MercatorProjection.pixelXToLongitude(pixelX, mapSize));
    }

    public static long getMapSizeWithScaleFactor(double scaleFactor, int tileSize) {
        if (scaleFactor < 1.0) {
            throw new IllegalArgumentException("scale factor must not < 1 " + scaleFactor);
        }
        return (long)((double)tileSize * Math.pow(2.0, MercatorProjection.scaleFactorToZoomLevel(scaleFactor)));
    }

    public static long getMapSize(byte zoomLevel, int tileSize) {
        if (zoomLevel < 0) {
            throw new IllegalArgumentException("zoom level must not be negative: " + zoomLevel);
        }
        return (long)tileSize << zoomLevel;
    }

    public static Point getPixelWithScaleFactor(LatLong latLong, double scaleFactor, int tileSize) {
        double pixelX = MercatorProjection.longitudeToPixelXWithScaleFactor(latLong.longitude, scaleFactor, tileSize);
        double pixelY = MercatorProjection.latitudeToPixelYWithScaleFactor(latLong.latitude, scaleFactor, tileSize);
        return new Point(pixelX, pixelY);
    }

    public static Point getPixel(LatLong latLong, long mapSize) {
        double pixelX = MercatorProjection.longitudeToPixelX(latLong.longitude, mapSize);
        double pixelY = MercatorProjection.latitudeToPixelY(latLong.latitude, mapSize);
        return new Point(pixelX, pixelY);
    }

    public static Point getPixelAbsolute(LatLong latLong, long mapSize) {
        return MercatorProjection.getPixelRelative(latLong, mapSize, 0.0, 0.0);
    }

    public static Point getPixelRelative(LatLong latLong, long mapSize, double x, double y) {
        double pixelX = MercatorProjection.longitudeToPixelX(latLong.longitude, mapSize) - x;
        double pixelY = MercatorProjection.latitudeToPixelY(latLong.latitude, mapSize) - y;
        return new Point(pixelX, pixelY);
    }

    public static Point getPixelRelative(LatLong latLong, long mapSize, Point origin) {
        return MercatorProjection.getPixelRelative(latLong, mapSize, origin.x, origin.y);
    }

    public static Point getPixelRelativeToTile(LatLong latLong, Tile tile) {
        return MercatorProjection.getPixelRelative(latLong, tile.mapSize, tile.getOrigin());
    }

    public static double latitudeToPixelYWithScaleFactor(double latitude, double scaleFactor, int tileSize) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        long mapSize = MercatorProjection.getMapSizeWithScaleFactor(scaleFactor, tileSize);
        double pixelY = (0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4)) * (double)mapSize;
        return Math.min(Math.max(0.0, pixelY), (double)mapSize);
    }

    public static double latitudeToPixelY(double latitude, byte zoomLevel, int tileSize) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        long mapSize = MercatorProjection.getMapSize(zoomLevel, tileSize);
        double pixelY = (0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4)) * (double)mapSize;
        return Math.min(Math.max(0.0, pixelY), (double)mapSize);
    }

    public static double latitudeToPixelY(double latitude, long mapSize) {
        double sinLatitude = Math.sin(latitude * (Math.PI / 180));
        double pixelY = (0.5 - Math.log((1.0 + sinLatitude) / (1.0 - sinLatitude)) / (Math.PI * 4)) * (double)mapSize;
        return Math.min(Math.max(0.0, pixelY), (double)mapSize);
    }

    public static int latitudeToTileY(double latitude, double scaleFactor) {
        return MercatorProjection.pixelYToTileY(MercatorProjection.latitudeToPixelYWithScaleFactor(latitude, scaleFactor, 256), scaleFactor, 256);
    }

    public static int latitudeToTileY(double latitude, byte zoomLevel) {
        return MercatorProjection.pixelYToTileY(MercatorProjection.latitudeToPixelY(latitude, zoomLevel, 256), zoomLevel, 256);
    }

    public static double longitudeToPixelXWithScaleFactor(double longitude, double scaleFactor, int tileSize) {
        long mapSize = MercatorProjection.getMapSizeWithScaleFactor(scaleFactor, tileSize);
        return (longitude + 180.0) / 360.0 * (double)mapSize;
    }

    public static double longitudeToPixelX(double longitude, long mapSize) {
        return (longitude + 180.0) / 360.0 * (double)mapSize;
    }

    public static int longitudeToTileX(double longitude, double scaleFactor) {
        return MercatorProjection.pixelXToTileX(MercatorProjection.longitudeToPixelXWithScaleFactor(longitude, scaleFactor, 256), scaleFactor, 256);
    }

    public static int longitudeToTileX(double longitude, byte zoomLevel) {
        return MercatorProjection.pixelXToTileX(MercatorProjection.longitudeToPixelX(longitude, MercatorProjection.getMapSize(zoomLevel, 256)), zoomLevel, 256);
    }

    public static double metersToPixelsWithScaleFactor(float meters, double latitude, double scaleFactor, int tileSize) {
        return (double)meters / MercatorProjection.calculateGroundResolutionWithScaleFactor(latitude, scaleFactor, tileSize);
    }

    public static double metersToPixels(float meters, double latitude, long mapSize) {
        return (double)meters / MercatorProjection.calculateGroundResolution(latitude, mapSize);
    }

    public static double pixelXToLongitudeWithScaleFactor(double pixelX, double scaleFactor, int tileSize) {
        long mapSize = MercatorProjection.getMapSizeWithScaleFactor(scaleFactor, tileSize);
        if (pixelX < 0.0 || pixelX > (double)mapSize) {
            throw new IllegalArgumentException("invalid pixelX coordinate at zoom level " + scaleFactor + ": " + pixelX);
        }
        return 360.0 * (pixelX / (double)mapSize - 0.5);
    }

    public static double pixelXToLongitude(double pixelX, long mapSize) {
        if (pixelX < 0.0 || pixelX > (double)mapSize) {
            throw new IllegalArgumentException("invalid pixelX coordinate " + mapSize + ": " + pixelX);
        }
        return 360.0 * (pixelX / (double)mapSize - 0.5);
    }

    public static int pixelXToTileX(double pixelX, double scaleFactor, int tileSize) {
        return (int)Math.min(Math.max(pixelX / (double)tileSize, 0.0), scaleFactor - 1.0);
    }

    public static int pixelXToTileX(double pixelX, byte zoomLevel, int tileSize) {
        return (int)Math.min(Math.max(pixelX / (double)tileSize, 0.0), Math.pow(2.0, zoomLevel) - 1.0);
    }

    public static double pixelYToLatitudeWithScaleFactor(double pixelY, double scaleFactor, int tileSize) {
        long mapSize = MercatorProjection.getMapSizeWithScaleFactor(scaleFactor, tileSize);
        if (pixelY < 0.0 || pixelY > (double)mapSize) {
            throw new IllegalArgumentException("invalid pixelY coordinate at zoom level " + scaleFactor + ": " + pixelY);
        }
        double y = 0.5 - pixelY / (double)mapSize;
        return 90.0 - 360.0 * Math.atan(Math.exp(-y * (Math.PI * 2))) / Math.PI;
    }

    public static double pixelYToLatitude(double pixelY, long mapSize) {
        if (pixelY < 0.0 || pixelY > (double)mapSize) {
            throw new IllegalArgumentException("invalid pixelY coordinate " + mapSize + ": " + pixelY);
        }
        double y = 0.5 - pixelY / (double)mapSize;
        return 90.0 - 360.0 * Math.atan(Math.exp(-y * (Math.PI * 2))) / Math.PI;
    }

    public static int pixelYToTileY(double pixelY, double scaleFactor, int tileSize) {
        return (int)Math.min(Math.max(pixelY / (double)tileSize, 0.0), scaleFactor - 1.0);
    }

    public static int pixelYToTileY(double pixelY, byte zoomLevel, int tileSize) {
        return (int)Math.min(Math.max(pixelY / (double)tileSize, 0.0), Math.pow(2.0, zoomLevel) - 1.0);
    }

    public static double scaleFactorToZoomLevel(double scaleFactor) {
        return Math.log(scaleFactor) / Math.log(2.0);
    }

    public static long tileToPixel(long tileNumber, int tileSize) {
        return tileNumber * (long)tileSize;
    }

    public static double tileXToLongitude(long tileX, double scaleFactor) {
        return MercatorProjection.pixelXToLongitudeWithScaleFactor(tileX * 256L, scaleFactor, 256);
    }

    public static double tileXToLongitude(long tileX, byte zoomLevel) {
        return MercatorProjection.pixelXToLongitude(tileX * 256L, MercatorProjection.getMapSize(zoomLevel, 256));
    }

    public static double tileYToLatitude(long tileY, double scaleFactor) {
        return MercatorProjection.pixelYToLatitudeWithScaleFactor(tileY * 256L, scaleFactor, 256);
    }

    public static double tileYToLatitude(long tileY, byte zoomLevel) {
        return MercatorProjection.pixelYToLatitude(tileY * 256L, MercatorProjection.getMapSize(zoomLevel, 256));
    }

    public static double zoomLevelToScaleFactor(byte zoomLevel) {
        return Math.pow(2.0, zoomLevel);
    }

    private MercatorProjection() {
        throw new IllegalStateException();
    }
}

