/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.graphics;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Path;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.map.awt.graphics.AwtGraphicFactory;
import org.mapsforge.map.awt.graphics.AwtPaint;
import org.mapsforge.map.awt.graphics.AwtPath;

class AwtCanvas
implements Canvas {
    private static final String UNKNOWN_STYLE = "unknown style: ";
    private BufferedImage bufferedImage;
    private Graphics2D graphics2D;

    AwtCanvas() {
    }

    AwtCanvas(Graphics2D graphics2D) {
        this.graphics2D = graphics2D;
        this.enableAntiAliasing();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void drawBitmap(Bitmap bitmap, int left, int top) {
        this.graphics2D.drawImage((Image)AwtGraphicFactory.getBufferedImage(bitmap), left, top, null);
    }

    @Override
    public void drawBitmap(Bitmap bitmap, Matrix matrix) {
        this.graphics2D.drawRenderedImage(AwtGraphicFactory.getBufferedImage(bitmap), AwtGraphicFactory.getAffineTransform(matrix));
    }

    @Override
    public void drawCircle(int x, int y, int radius, Paint paint) {
        if (paint.isTransparent()) {
            return;
        }
        AwtPaint awtPaint = AwtGraphicFactory.getPaint(paint);
        this.setColorAndStroke(awtPaint);
        int doubleRadius = radius * 2;
        Style style = awtPaint.style;
        switch (style) {
            case FILL: {
                this.graphics2D.fillOval(x - radius, y - radius, doubleRadius, doubleRadius);
                return;
            }
            case STROKE: {
                this.graphics2D.drawOval(x - radius, y - radius, doubleRadius, doubleRadius);
                return;
            }
        }
        throw new IllegalArgumentException(UNKNOWN_STYLE + (Object)((Object)style));
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, Paint paint) {
        if (paint.isTransparent()) {
            return;
        }
        this.setColorAndStroke(AwtGraphicFactory.getPaint(paint));
        this.graphics2D.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawPath(Path path, Paint paint) {
        if (paint.isTransparent()) {
            return;
        }
        AwtPaint awtPaint = AwtGraphicFactory.getPaint(paint);
        AwtPath awtPath = AwtGraphicFactory.getPath(path);
        this.setColorAndStroke(awtPaint);
        this.graphics2D.setPaint(awtPaint.texturePaint);
        Style style = awtPaint.style;
        switch (style) {
            case FILL: {
                this.graphics2D.fill(awtPath.path2D);
                return;
            }
            case STROKE: {
                this.graphics2D.draw(awtPath.path2D);
                return;
            }
        }
        throw new IllegalArgumentException(UNKNOWN_STYLE + (Object)((Object)style));
    }

    @Override
    public void drawText(String text, int x, int y, Paint paint) {
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        if (paint.isTransparent()) {
            return;
        }
        AwtPaint awtPaint = AwtGraphicFactory.getPaint(paint);
        if (awtPaint.stroke == null) {
            this.graphics2D.setColor(awtPaint.color);
            this.graphics2D.setFont(awtPaint.font);
            this.graphics2D.drawString(text, x, y);
        } else {
            this.setColorAndStroke(awtPaint);
            TextLayout textLayout = new TextLayout(text, awtPaint.font, this.graphics2D.getFontRenderContext());
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(x, y);
            this.graphics2D.draw(textLayout.getOutline(affineTransform));
        }
    }

    @Override
    public void drawTextRotated(String text, int x1, int y1, int x2, int y2, Paint paint) {
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        if (paint.isTransparent()) {
            return;
        }
        AffineTransform affineTransform = this.graphics2D.getTransform();
        double theta = Math.atan2(y2 - y1, x2 - x1);
        this.graphics2D.rotate(theta, x1, y1);
        double lineLength = Math.hypot(x2 - x1, y2 - y1);
        int textWidth = paint.getTextWidth(text);
        int dx = (int)(lineLength - (double)textWidth) / 2;
        int xy = paint.getTextHeight(text) / 3;
        this.drawText(text, x1 + dx, y1 + xy, paint);
        this.graphics2D.setTransform(affineTransform);
    }

    @Override
    public void fillColor(org.mapsforge.core.graphics.Color color) {
        this.fillColor(AwtGraphicFactory.getColor(color));
    }

    @Override
    public void fillColor(int color) {
        this.fillColor(new Color(color));
    }

    @Override
    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    Graphics2D getGraphicObject() {
        return this.graphics2D;
    }

    @Override
    public int getHeight() {
        return this.bufferedImage != null ? this.bufferedImage.getHeight() : 0;
    }

    @Override
    public int getWidth() {
        return this.bufferedImage != null ? this.bufferedImage.getWidth() : 0;
    }

    @Override
    public void resetClip() {
        this.graphics2D.setClip(null);
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            this.bufferedImage = null;
            this.graphics2D = null;
        } else {
            this.bufferedImage = AwtGraphicFactory.getBufferedImage(bitmap);
            this.graphics2D = this.bufferedImage.createGraphics();
            this.enableAntiAliasing();
            this.graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            this.graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
    }

    @Override
    public void setClip(int left, int top, int width, int height) {
        this.graphics2D.setClip(left, top, width, height);
    }

    @Override
    public void setClipDifference(int left, int top, int width, int height) {
        Area clip = new Area(new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight()));
        clip.subtract(new Area(new Rectangle2D.Double(left, top, width, height)));
        this.graphics2D.setClip(clip);
    }

    private void enableAntiAliasing() {
        this.graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
    }

    private void fillColor(Color color) {
        Composite originalComposite = this.graphics2D.getComposite();
        this.graphics2D.setComposite(AlphaComposite.getInstance(2));
        this.graphics2D.setColor(color);
        this.graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.graphics2D.setComposite(originalComposite);
    }

    public void setColorAndStroke(AwtPaint awtPaint) {
        this.graphics2D.setColor(awtPaint.color);
        if (awtPaint.stroke != null) {
            this.graphics2D.setStroke(awtPaint.stroke);
        }
    }
}

