/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.graphics;

import com.kitfox.svg.SVGCache;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.GraphicContext;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Path;
import org.mapsforge.core.graphics.Position;
import org.mapsforge.core.graphics.ResourceBitmap;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.mapelements.PointTextContainer;
import org.mapsforge.core.mapelements.SymbolContainer;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.awt.graphics.AwtBitmap;
import org.mapsforge.map.awt.graphics.AwtCanvas;
import org.mapsforge.map.awt.graphics.AwtMatrix;
import org.mapsforge.map.awt.graphics.AwtPaint;
import org.mapsforge.map.awt.graphics.AwtPath;
import org.mapsforge.map.awt.graphics.AwtPointTextContainer;
import org.mapsforge.map.awt.graphics.AwtResourceBitmap;
import org.mapsforge.map.awt.graphics.AwtSvgBitmap;
import org.mapsforge.map.awt.graphics.AwtTileBitmap;

public class AwtGraphicFactory
implements GraphicFactory {
    public static final GraphicFactory INSTANCE = new AwtGraphicFactory();
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);

    public static GraphicContext createGraphicContext(Graphics graphics) {
        return new AwtCanvas((Graphics2D)graphics);
    }

    static AffineTransform getAffineTransform(Matrix matrix) {
        return ((AwtMatrix)matrix).affineTransform;
    }

    public static AwtPaint getPaint(Paint paint) {
        return (AwtPaint)paint;
    }

    static AwtPath getPath(Path path) {
        return (AwtPath)path;
    }

    static BufferedImage getBufferedImage(Bitmap bitmap) {
        return ((AwtBitmap)bitmap).bufferedImage;
    }

    static Color getColor(org.mapsforge.core.graphics.Color color) {
        switch (color) {
            case BLACK: {
                return Color.BLACK;
            }
            case BLUE: {
                return Color.BLUE;
            }
            case GREEN: {
                return Color.GREEN;
            }
            case RED: {
                return Color.RED;
            }
            case TRANSPARENT: {
                return TRANSPARENT;
            }
            case WHITE: {
                return Color.WHITE;
            }
        }
        throw new IllegalArgumentException("unknown color: " + (Object)((Object)color));
    }

    public static void clearResourceFileCache() {
    }

    public static void clearResourceMemoryCache() {
        SVGCache.getSVGUniverse().clear();
    }

    @Override
    public Bitmap createBitmap(int width, int height) {
        return new AwtBitmap(width, height);
    }

    @Override
    public Bitmap createBitmap(int width, int height, boolean isTransparent) {
        if (isTransparent) {
            throw new UnsupportedOperationException("No transparencies in AWT implementation");
        }
        return new AwtBitmap(width, height);
    }

    public static BufferedImage getBitmap(Bitmap bitmap) {
        return ((AwtBitmap)bitmap).bufferedImage;
    }

    @Override
    public Canvas createCanvas() {
        return new AwtCanvas();
    }

    @Override
    public int createColor(org.mapsforge.core.graphics.Color color) {
        return AwtGraphicFactory.getColor(color).getRGB();
    }

    @Override
    public int createColor(int alpha, int red, int green, int blue) {
        return new Color(red, green, blue, alpha).getRGB();
    }

    @Override
    public Matrix createMatrix() {
        return new AwtMatrix();
    }

    @Override
    public Paint createPaint() {
        return new AwtPaint();
    }

    @Override
    public Paint createPaint(Paint paint) {
        return new AwtPaint(paint);
    }

    @Override
    public Path createPath() {
        return new AwtPath();
    }

    @Override
    public PointTextContainer createPointTextContainer(Point xy, Display display, int priority, String text, Paint paintFront, Paint paintBack, SymbolContainer symbolContainer, Position position, int maxTextWidth) {
        return new AwtPointTextContainer(xy, display, priority, text, paintFront, paintBack, symbolContainer, position, maxTextWidth);
    }

    @Override
    public ResourceBitmap createResourceBitmap(InputStream inputStream, int hash) throws IOException {
        return new AwtResourceBitmap(inputStream);
    }

    @Override
    public TileBitmap createTileBitmap(InputStream inputStream, int tileSize, boolean hasAlpha) throws IOException {
        return new AwtTileBitmap(inputStream);
    }

    @Override
    public TileBitmap createTileBitmap(int tileSize, boolean hasAlpha) {
        return new AwtTileBitmap(tileSize, hasAlpha);
    }

    @Override
    public InputStream platformSpecificSources(String relativePathPrefix, String src) throws FileNotFoundException {
        return null;
    }

    @Override
    public ResourceBitmap renderSvg(InputStream inputStream, float scaleFactor, int width, int height, int percent, int hash) throws IOException {
        return new AwtSvgBitmap(inputStream, hash, scaleFactor, width, height, percent);
    }
}

