/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.graphics;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Position;
import org.mapsforge.core.mapelements.PointTextContainer;
import org.mapsforge.core.mapelements.SymbolContainer;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.map.awt.graphics.AwtCanvas;
import org.mapsforge.map.awt.graphics.AwtGraphicFactory;
import org.mapsforge.map.awt.graphics.AwtPaint;

public class AwtPointTextContainer
extends PointTextContainer {
    AwtPointTextContainer(Point xy, Display display, int priority, String text, Paint paintFront, Paint paintBack, SymbolContainer symbolContainer, Position position, int maxTextWidth) {
        super(xy, display, priority, text, paintFront, paintBack, symbolContainer, position, maxTextWidth);
        this.boundary = this.computeBoundary();
    }

    @Override
    public void draw(Canvas canvas, Point origin, Matrix matrix) {
        if (this.paintFront.isTransparent() && (this.paintBack == null || this.paintBack.isTransparent())) {
            return;
        }
        AwtCanvas awtCanvas = (AwtCanvas)canvas;
        Point pointAdjusted = this.xy.offset(-origin.x, -origin.y);
        int textWidth = this.paintFront.getTextWidth(this.text);
        if (textWidth > this.maxTextWidth) {
            AttributedString attrString = new AttributedString(this.text);
            AwtPaint awtPaintFront = AwtGraphicFactory.getPaint(this.paintFront);
            attrString.addAttribute(TextAttribute.FOREGROUND, awtPaintFront.color);
            attrString.addAttribute(TextAttribute.FONT, awtPaintFront.font);
            AttributedCharacterIterator paragraph = attrString.getIterator();
            int paragraphStart = paragraph.getBeginIndex();
            int paragraphEnd = paragraph.getEndIndex();
            FontRenderContext frc = awtCanvas.getGraphicObject().getFontRenderContext();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(paragraph, frc);
            float layoutHeight = 0.0f;
            lineMeasurer.setPosition(paragraphStart);
            while (lineMeasurer.getPosition() < paragraphEnd) {
                TextLayout layout = lineMeasurer.nextLayout(this.maxTextWidth);
                layoutHeight += layout.getAscent() + layout.getDescent() + layout.getLeading();
            }
            float drawPosY = (float)pointAdjusted.y;
            lineMeasurer.setPosition(paragraphStart);
            while (lineMeasurer.getPosition() < paragraphEnd) {
                TextLayout layout = lineMeasurer.nextLayout(this.maxTextWidth);
                float posX = (float)pointAdjusted.x;
                float posY = drawPosY;
                if (Position.CENTER == this.position) {
                    posX += -layout.getAdvance() * 0.5f;
                    posY += layout.getAscent() - layoutHeight * 0.5f;
                } else if (Position.BELOW == this.position) {
                    posX += -layout.getAdvance() * 0.5f;
                    posY += (layout.getAscent() + layout.getDescent() + layout.getLeading()) * 0.5f;
                } else if (Position.BELOW_LEFT == this.position) {
                    posX += -layout.getAdvance();
                    posY += (layout.getAscent() + layout.getDescent() + layout.getLeading()) * 0.5f;
                } else if (Position.BELOW_RIGHT == this.position) {
                    posY += (layout.getAscent() + layout.getDescent() + layout.getLeading()) * 0.5f;
                } else if (Position.ABOVE == this.position) {
                    posX += -layout.getAdvance() * 0.5f;
                    posY += layout.getAscent() + layout.getDescent() + layout.getLeading() - layoutHeight;
                } else if (Position.ABOVE_LEFT == this.position) {
                    posX += -layout.getAdvance();
                    posY += layout.getAscent() + layout.getDescent() + layout.getLeading() - layoutHeight;
                } else if (Position.ABOVE_RIGHT == this.position) {
                    posY += layout.getAscent() + layout.getDescent() + layout.getLeading() - layoutHeight;
                } else if (Position.LEFT == this.position) {
                    posX += -layout.getAdvance();
                    posY += layout.getAscent() - layoutHeight * 0.5f;
                } else if (Position.RIGHT == this.position) {
                    posY += layout.getAscent() - layoutHeight * 0.5f;
                } else {
                    throw new IllegalArgumentException("No position for drawing PointTextContainer");
                }
                if (this.paintBack != null) {
                    awtCanvas.setColorAndStroke(AwtGraphicFactory.getPaint(this.paintBack));
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.translate(posX, posY);
                    awtCanvas.getGraphicObject().draw(layout.getOutline(affineTransform));
                }
                layout.draw(awtCanvas.getGraphicObject(), posX, posY);
                drawPosY += layout.getAscent() + layout.getDescent() + layout.getLeading();
            }
        } else {
            if (this.paintBack != null) {
                canvas.drawText(this.text, (int)(pointAdjusted.x + this.boundary.left), (int)(pointAdjusted.y + this.boundary.top + (double)this.textHeight), this.paintBack);
            }
            canvas.drawText(this.text, (int)(pointAdjusted.x + this.boundary.left), (int)(pointAdjusted.y + this.boundary.top + (double)this.textHeight), this.paintFront);
        }
    }

    private Rectangle computeBoundary() {
        int lines = this.textWidth / this.maxTextWidth + 1;
        double boxWidth = this.textWidth;
        double boxHeight = this.textHeight;
        if (lines > 1) {
            boxWidth = this.maxTextWidth;
            boxHeight = this.textHeight * lines;
        }
        switch (this.position) {
            case CENTER: {
                return new Rectangle(-boxWidth / 2.0, -boxHeight / 2.0, boxWidth / 2.0, boxHeight / 2.0);
            }
            case BELOW: {
                return new Rectangle(-boxWidth / 2.0, 0.0, boxWidth / 2.0, boxHeight);
            }
            case BELOW_LEFT: {
                return new Rectangle(-boxWidth, 0.0, 0.0, boxHeight);
            }
            case BELOW_RIGHT: {
                return new Rectangle(0.0, 0.0, boxWidth, boxHeight);
            }
            case ABOVE: {
                return new Rectangle(-boxWidth / 2.0, -boxHeight, boxWidth / 2.0, 0.0);
            }
            case ABOVE_LEFT: {
                return new Rectangle(-boxWidth, -boxHeight, 0.0, 0.0);
            }
            case ABOVE_RIGHT: {
                return new Rectangle(0.0, -boxHeight, boxWidth, 0.0);
            }
            case LEFT: {
                return new Rectangle(-boxWidth, -boxHeight / 2.0, 0.0, boxHeight / 2.0);
            }
            case RIGHT: {
                return new Rectangle(0.0, -boxHeight / 2.0, boxWidth, boxHeight / 2.0);
            }
        }
        return null;
    }
}

