/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.awt.input;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.SwingUtilities;
import org.mapsforge.map.model.MapViewPosition;

public class MouseEventListener
extends MouseAdapter {
    private final MapViewPosition mapViewPosition;
    private Point lastDragPoint;

    public MouseEventListener(MapViewPosition mapViewPosition) {
        this.mapViewPosition = mapViewPosition;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            Point point = mouseEvent.getPoint();
            if (this.lastDragPoint != null) {
                int moveHorizontal = point.x - this.lastDragPoint.x;
                int moveVertical = point.y - this.lastDragPoint.y;
                this.mapViewPosition.moveCenter(moveHorizontal, moveVertical);
            }
            this.lastDragPoint = point;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.lastDragPoint = mouseEvent.getPoint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.lastDragPoint = null;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        byte zoomLevelDiff = (byte)(-mouseWheelEvent.getWheelRotation());
        this.mapViewPosition.zoom(zoomLevelDiff);
    }
}

