/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.controller;

import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.model.MapViewPosition;
import org.mapsforge.map.model.Model;
import org.mapsforge.map.model.common.Observer;
import org.mapsforge.map.view.FrameBuffer;

public final class FrameBufferController
implements Observer {
    private static float maxAspectRatio = 2.0f;
    private static boolean useSquareFrameBuffer = true;
    private final FrameBuffer frameBuffer;
    private Dimension lastMapViewDimension;
    private double lastOverdrawFactor;
    private final Model model;

    public static FrameBufferController create(FrameBuffer frameBuffer, Model model) {
        FrameBufferController frameBufferController = new FrameBufferController(frameBuffer, model);
        model.frameBufferModel.addObserver(frameBufferController);
        model.mapViewDimension.addObserver(frameBufferController);
        model.mapViewPosition.addObserver(frameBufferController);
        model.displayModel.addObserver(frameBufferController);
        return frameBufferController;
    }

    public static Dimension calculateFrameBufferDimension(Dimension mapViewDimension, double overdrawFactor) {
        float aspectRatio;
        int width = (int)((double)mapViewDimension.width * overdrawFactor);
        int height = (int)((double)mapViewDimension.height * overdrawFactor);
        if (useSquareFrameBuffer && (aspectRatio = (float)mapViewDimension.width / (float)mapViewDimension.height) < maxAspectRatio && aspectRatio > 1.0f / maxAspectRatio) {
            height = width = Math.max(width, height);
        }
        return new Dimension(width, height);
    }

    public static boolean isUseSquareFrameBuffer() {
        return useSquareFrameBuffer;
    }

    public static void setUseSquareFrameBuffer(boolean useSquareFrameBuffer) {
        FrameBufferController.useSquareFrameBuffer = useSquareFrameBuffer;
    }

    private FrameBufferController(FrameBuffer frameBuffer, Model model) {
        this.frameBuffer = frameBuffer;
        this.model = model;
    }

    public void destroy() {
        this.model.mapViewPosition.removeObserver(this);
        this.model.mapViewDimension.removeObserver(this);
        this.model.frameBufferModel.removeObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onChange() {
        Dimension mapViewDimension = this.model.mapViewDimension.getDimension();
        if (mapViewDimension == null) {
            return;
        }
        double overdrawFactor = this.model.frameBufferModel.getOverdrawFactor();
        if (this.dimensionChangeNeeded(mapViewDimension, overdrawFactor)) {
            Dimension newDimension = FrameBufferController.calculateFrameBufferDimension(mapViewDimension, overdrawFactor);
            if (!useSquareFrameBuffer || this.frameBuffer.getDimension() == null || newDimension.width > this.frameBuffer.getDimension().width || newDimension.height > this.frameBuffer.getDimension().height) {
                this.frameBuffer.setDimension(newDimension);
            }
            this.lastMapViewDimension = mapViewDimension;
            this.lastOverdrawFactor = overdrawFactor;
        }
        MapViewPosition mapViewPosition = this.model.mapViewPosition;
        synchronized (mapViewPosition) {
            FrameBuffer frameBuffer = this.frameBuffer;
            synchronized (frameBuffer) {
                MapPosition mapPositionFrameBuffer = this.model.frameBufferModel.getMapPosition();
                if (mapPositionFrameBuffer != null) {
                    double scaleFactor = this.model.mapViewPosition.getScaleFactor();
                    LatLong pivot = this.model.mapViewPosition.getPivot();
                    this.adjustFrameBufferMatrix(mapPositionFrameBuffer, mapViewDimension, scaleFactor, pivot);
                }
            }
        }
    }

    private void adjustFrameBufferMatrix(MapPosition mapPositionFrameBuffer, Dimension mapViewDimension, double scaleFactor, LatLong pivot) {
        MapPosition mapViewPosition = this.model.mapViewPosition.getMapPosition();
        long mapSize = MercatorProjection.getMapSize(mapPositionFrameBuffer.zoomLevel, this.model.displayModel.getTileSize());
        Point pointFrameBuffer = MercatorProjection.getPixel(mapPositionFrameBuffer.latLong, mapSize);
        Point pointMapPosition = MercatorProjection.getPixel(mapViewPosition.latLong, mapSize);
        double diffX = pointFrameBuffer.x - pointMapPosition.x;
        double diffY = pointFrameBuffer.y - pointMapPosition.y;
        double pivotDistanceX = 0.0;
        double pivotDistanceY = 0.0;
        if (pivot != null) {
            Point pivotXY = MercatorProjection.getPixel(pivot, mapSize);
            pivotDistanceX = pivotXY.x - pointFrameBuffer.x;
            pivotDistanceY = pivotXY.y - pointFrameBuffer.y;
        }
        float currentScaleFactor = (float)(scaleFactor / Math.pow(2.0, mapPositionFrameBuffer.zoomLevel));
        this.frameBuffer.adjustMatrix((float)diffX, (float)diffY, currentScaleFactor, mapViewDimension, (float)pivotDistanceX, (float)pivotDistanceY);
    }

    private boolean dimensionChangeNeeded(Dimension mapViewDimension, double overdrawFactor) {
        if (Double.compare(overdrawFactor, this.lastOverdrawFactor) != 0) {
            return true;
        }
        return !mapViewDimension.equals(this.lastMapViewDimension);
    }
}

