/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.datastore;

import java.util.Locale;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.datastore.MapReadResult;

public abstract class MapDataStore {
    protected String preferredLanguage;

    public static String extract(String s, String language) {
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        String[] langNames = s.split("\r");
        if (language == null || language.trim().isEmpty()) {
            return langNames[0];
        }
        String fallback = null;
        for (int i = 1; i < langNames.length; ++i) {
            String[] langName = langNames[i].split("\b");
            if (langName.length != 2) continue;
            if (langName[0].equalsIgnoreCase(language)) {
                return langName[1];
            }
            if (fallback != null || langName[0].contains("-") || !language.contains("-") && !language.contains("_") || !language.toLowerCase(Locale.ENGLISH).startsWith(langName[0].toLowerCase(Locale.ENGLISH))) continue;
            fallback = langName[1];
        }
        return fallback != null ? fallback : langNames[0];
    }

    public MapDataStore() {
        this(null);
    }

    public MapDataStore(String language) {
        this.preferredLanguage = language;
    }

    public abstract BoundingBox boundingBox();

    public abstract void close();

    protected String extractLocalized(String s) {
        return MapDataStore.extract(s, this.preferredLanguage);
    }

    public abstract long getDataTimestamp(Tile var1);

    public abstract MapReadResult readMapData(Tile var1);

    public abstract LatLong startPosition();

    public abstract Byte startZoomLevel();

    public abstract boolean supportsTile(Tile var1);
}

