/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.CorruptedInputStreamException;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.util.IOUtils;
import org.mapsforge.map.layer.cache.FileWorkingSetCache;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.queue.Job;
import org.mapsforge.map.model.common.Observable;
import org.mapsforge.map.model.common.Observer;

public class FileSystemTileCache
implements TileCache {
    static final String FILE_EXTENSION = ".tile";
    private static final Logger LOGGER = Logger.getLogger(FileSystemTileCache.class.getName());
    private final File cacheDirectory;
    private final GraphicFactory graphicFactory;
    private FileWorkingSetCache<String> lruCache;
    private final ReentrantReadWriteLock lock;
    private final Observable observable = new Observable();
    private final boolean persistent;

    private static boolean isValidCacheDirectory(File file) {
        return file != null && (file.exists() || file.mkdirs()) && file.isDirectory() && file.canRead() && file.canWrite();
    }

    private static boolean isValidFile(File file) {
        return file != null && file.isFile() && file.canRead();
    }

    private static boolean deleteDirectory(File dir2) {
        String[] children;
        if (dir2 == null) {
            return false;
        }
        if (dir2.isDirectory() && (children = dir2.list()) != null) {
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileSystemTileCache.deleteDirectory(new File(dir2, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir2.delete();
    }

    public FileSystemTileCache(int capacity, File cacheDirectory, GraphicFactory graphicFactory) {
        this(capacity, cacheDirectory, graphicFactory, false);
    }

    public FileSystemTileCache(int capacity, File cacheDirectory, GraphicFactory graphicFactory, boolean persistent) {
        this.persistent = persistent;
        this.lruCache = new FileWorkingSetCache(capacity);
        this.lock = new ReentrantReadWriteLock();
        if (FileSystemTileCache.isValidCacheDirectory(cacheDirectory)) {
            this.cacheDirectory = cacheDirectory;
            if (this.persistent) {
                new Thread(new CacheDirectoryReader()).start();
            }
        } else {
            this.cacheDirectory = null;
        }
        this.graphicFactory = graphicFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Job key) {
        try {
            this.lock.readLock().lock();
            boolean bl = this.lruCache.containsKey(key.getKey());
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public void destroy() {
        if (!this.persistent) {
            this.purge();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public TileBitmap get(Job key) {
        TileBitmap tileBitmap;
        File file;
        try {
            this.lock.readLock().lock();
            file = (File)this.lruCache.get(key.getKey());
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (file == null) {
            return null;
        }
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            TileBitmap result = this.graphicFactory.createTileBitmap(inputStream, key.tile.tileSize, key.hasAlpha);
            result.setTimestamp(file.lastModified());
            tileBitmap = result;
        }
        catch (CorruptedInputStreamException e) {
            this.remove(key);
            LOGGER.log(Level.WARNING, "input stream from file system cache invalid " + key.getKey() + " " + file.length(), e);
            TileBitmap tileBitmap2 = null;
            IOUtils.closeQuietly(inputStream);
            return tileBitmap2;
        }
        catch (IOException e2) {
            this.remove(key);
            LOGGER.log(Level.SEVERE, e2.getMessage(), e2);
            TileBitmap tileBitmap3 = null;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(inputStream);
            return tileBitmap3;
        }
        IOUtils.closeQuietly(inputStream);
        return tileBitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getCapacity() {
        try {
            this.lock.readLock().lock();
            int n = this.lruCache.capacity;
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getCapacityFirstLevel() {
        return this.getCapacity();
    }

    @Override
    public TileBitmap getImmediately(Job key) {
        return this.get(key);
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purge() {
        try {
            this.lock.writeLock().lock();
            this.lruCache.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        FileSystemTileCache.deleteDirectory(this.cacheDirectory);
    }

    @Override
    public void put(Job key, TileBitmap bitmap) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        if (this.getCapacity() == 0) {
            return;
        }
        this.storeData(key, bitmap);
        this.observable.notifyObservers();
    }

    @Override
    public void setWorkingSet(Set<Job> workingSet) {
        HashSet<String> workingSetInteger = new HashSet<String>();
        for (Job job : workingSet) {
            workingSetInteger.add(job.getKey());
        }
        this.lruCache.setWorkingSet(workingSetInteger);
    }

    @Override
    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    @Override
    public void removeObserver(Observer observer) {
        this.observable.removeObserver(observer);
    }

    private File getOutputFile(Job job) {
        String file = this.cacheDirectory + File.separator + job.getKey();
        String dir2 = file.substring(0, file.lastIndexOf(File.separatorChar));
        if (FileSystemTileCache.isValidCacheDirectory(new File(dir2))) {
            return new File(file + FILE_EXTENSION);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(Job key) {
        try {
            this.lock.writeLock().lock();
            this.lruCache.remove(key.getKey());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeData(Job key, TileBitmap bitmap) {
        File file;
        FileOutputStream outputStream;
        block12: {
            outputStream = null;
            file = this.getOutputFile(key);
            if (file != null) break block12;
            IOUtils.closeQuietly(outputStream);
            return;
        }
        try {
            outputStream = new FileOutputStream(file);
            bitmap.compress(outputStream);
            try {
                this.lock.writeLock().lock();
                if (this.lruCache.put(key.getKey(), file) != null) {
                    LOGGER.warning("overwriting cached entry: " + key.getKey());
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.SEVERE, "Disabling filesystem cache", e);
                this.destroy();
                try {
                    this.lock.writeLock().lock();
                    this.lruCache = new FileWorkingSetCache(0);
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream);
                throw throwable;
            }
            IOUtils.closeQuietly(outputStream);
        }
        IOUtils.closeQuietly(outputStream);
    }

    private class CacheDirectoryReader
    implements Runnable {
        private CacheDirectoryReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            File[] zFiles = FileSystemTileCache.this.cacheDirectory.listFiles();
            if (zFiles != null) {
                for (File z : zFiles) {
                    File[] xFiles = z.listFiles();
                    if (xFiles == null) continue;
                    for (File x : xFiles) {
                        File[] yFiles = x.listFiles();
                        if (yFiles == null) continue;
                        for (File y : yFiles) {
                            if (!FileSystemTileCache.isValidFile(y) || !y.getName().endsWith(FileSystemTileCache.FILE_EXTENSION)) continue;
                            int index = y.getName().lastIndexOf(FileSystemTileCache.FILE_EXTENSION);
                            String key = Job.composeKey(z.getName(), x.getName(), y.getName().substring(0, index));
                            try {
                                FileSystemTileCache.this.lock.writeLock().lock();
                                if (FileSystemTileCache.this.lruCache.put(key, y) == null) continue;
                                LOGGER.warning("overwriting cached entry: " + key);
                            }
                            finally {
                                FileSystemTileCache.this.lock.writeLock().unlock();
                            }
                        }
                    }
                }
            }
        }
    }
}

