/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.cache;

import java.util.Set;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.map.layer.cache.BitmapLRUCache;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.queue.Job;
import org.mapsforge.map.model.common.Observable;
import org.mapsforge.map.model.common.Observer;

public class InMemoryTileCache
implements TileCache {
    private static final Logger LOGGER = Logger.getLogger(InMemoryTileCache.class.getName());
    private BitmapLRUCache lruCache;
    private Observable observable;

    public InMemoryTileCache(int capacity) {
        this.lruCache = new BitmapLRUCache(capacity);
        this.observable = new Observable();
    }

    @Override
    public synchronized boolean containsKey(Job key) {
        return this.lruCache.containsKey(key);
    }

    @Override
    public synchronized void destroy() {
        this.purge();
    }

    @Override
    public synchronized TileBitmap get(Job key) {
        TileBitmap bitmap = (TileBitmap)this.lruCache.get(key);
        if (bitmap != null) {
            bitmap.incrementRefCount();
        }
        return bitmap;
    }

    @Override
    public synchronized int getCapacity() {
        return this.lruCache.capacity;
    }

    @Override
    public int getCapacityFirstLevel() {
        return this.getCapacity();
    }

    @Override
    public TileBitmap getImmediately(Job key) {
        return this.get(key);
    }

    @Override
    public void purge() {
        for (TileBitmap bitmap : this.lruCache.values()) {
            bitmap.decrementRefCount();
        }
        this.lruCache.clear();
    }

    @Override
    public synchronized void put(Job key, TileBitmap bitmap) {
        if (key == null) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (bitmap == null) {
            throw new IllegalArgumentException("bitmap must not be null");
        }
        TileBitmap old = (TileBitmap)this.lruCache.get(key);
        if (old != null) {
            old.decrementRefCount();
        }
        if (this.lruCache.put(key, bitmap) != null) {
            LOGGER.warning("overwriting cached entry: " + key);
        }
        bitmap.incrementRefCount();
        this.observable.notifyObservers();
    }

    public synchronized void setCapacity(int capacity) {
        BitmapLRUCache lruCacheNew = new BitmapLRUCache(capacity);
        lruCacheNew.putAll(this.lruCache);
        this.lruCache = lruCacheNew;
    }

    @Override
    public synchronized void setWorkingSet(Set<Job> jobs) {
        this.lruCache.setWorkingSet(jobs);
    }

    @Override
    public void addObserver(Observer observer) {
        this.observable.addObserver(observer);
    }

    @Override
    public void removeObserver(Observer observer) {
        this.observable.removeObserver(observer);
    }
}

