/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.debug;

import java.util.List;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.FontFamily;
import org.mapsforge.core.graphics.FontStyle;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.layer.TilePosition;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.util.LayerUtil;

public class TileCoordinatesLayer
extends Layer {
    private final DisplayModel displayModel;
    private final Paint paintBack;
    private final Paint paintFront;

    private static Paint createPaintFront(GraphicFactory graphicFactory, DisplayModel displayModel) {
        Paint paint = graphicFactory.createPaint();
        paint.setColor(Color.RED);
        paint.setTypeface(FontFamily.DEFAULT, FontStyle.BOLD);
        paint.setTextSize(16.0f * displayModel.getScaleFactor());
        return paint;
    }

    private static Paint createPaintBack(GraphicFactory graphicFactory, DisplayModel displayModel) {
        Paint paint = graphicFactory.createPaint();
        paint.setColor(Color.WHITE);
        paint.setTypeface(FontFamily.DEFAULT, FontStyle.BOLD);
        paint.setTextSize(16.0f * displayModel.getScaleFactor());
        paint.setStrokeWidth(2.0f * displayModel.getScaleFactor());
        paint.setStyle(Style.STROKE);
        return paint;
    }

    public TileCoordinatesLayer(GraphicFactory graphicFactory, DisplayModel displayModel) {
        this.displayModel = displayModel;
        this.paintBack = TileCoordinatesLayer.createPaintBack(graphicFactory, displayModel);
        this.paintFront = TileCoordinatesLayer.createPaintFront(graphicFactory, displayModel);
    }

    public TileCoordinatesLayer(DisplayModel displayModel, Paint paintBack, Paint paintFront) {
        this.displayModel = displayModel;
        this.paintBack = paintBack;
        this.paintFront = paintFront;
    }

    @Override
    public void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        List<TilePosition> tilePositions = LayerUtil.getTilePositions(boundingBox, zoomLevel, topLeftPoint, this.displayModel.getTileSize());
        for (int i = tilePositions.size() - 1; i >= 0; --i) {
            this.drawTileCoordinates(tilePositions.get(i), canvas);
        }
    }

    private void drawTileCoordinates(TilePosition tilePosition, Canvas canvas) {
        int x = (int)(tilePosition.point.x + (double)(8.0f * this.displayModel.getScaleFactor()));
        int y = (int)(tilePosition.point.y + (double)(24.0f * this.displayModel.getScaleFactor()));
        Tile tile = tilePosition.tile;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("X: ");
        stringBuilder.append(tile.tileX);
        String text = stringBuilder.toString();
        canvas.drawText(text, x, y, this.paintBack);
        canvas.drawText(text, x, y, this.paintFront);
        stringBuilder.setLength(0);
        stringBuilder.append("Y: ");
        stringBuilder.append(tile.tileY);
        text = stringBuilder.toString();
        canvas.drawText(text, x, (int)((float)y + 24.0f * this.displayModel.getScaleFactor()), this.paintBack);
        canvas.drawText(text, x, (int)((float)y + 24.0f * this.displayModel.getScaleFactor()), this.paintFront);
        stringBuilder.setLength(0);
        stringBuilder.append("Z: ");
        stringBuilder.append(tile.zoomLevel);
        text = stringBuilder.toString();
        canvas.drawText(text, x, (int)((float)y + 48.0f * this.displayModel.getScaleFactor()), this.paintBack);
        canvas.drawText(text, x, (int)((float)y + 48.0f * this.displayModel.getScaleFactor()), this.paintFront);
    }
}

