/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.debug;

import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.model.DisplayModel;

public class TileGridLayer
extends Layer {
    private final DisplayModel displayModel;
    private final Paint paintBack;
    private final Paint paintFront;

    private static Paint createPaintFront(GraphicFactory graphicFactory, DisplayModel displayModel) {
        Paint paint = graphicFactory.createPaint();
        paint.setColor(Color.RED);
        paint.setStrokeWidth(2.0f * displayModel.getScaleFactor());
        paint.setStyle(Style.STROKE);
        return paint;
    }

    private static Paint createPaintBack(GraphicFactory graphicFactory, DisplayModel displayModel) {
        Paint paint = graphicFactory.createPaint();
        paint.setColor(Color.WHITE);
        paint.setStrokeWidth(4.0f * displayModel.getScaleFactor());
        paint.setStyle(Style.STROKE);
        return paint;
    }

    public TileGridLayer(GraphicFactory graphicFactory, DisplayModel displayModel) {
        this.displayModel = displayModel;
        this.paintBack = TileGridLayer.createPaintBack(graphicFactory, displayModel);
        this.paintFront = TileGridLayer.createPaintFront(graphicFactory, displayModel);
    }

    public TileGridLayer(DisplayModel displayModel, Paint paintBack, Paint paintFront) {
        this.displayModel = displayModel;
        this.paintBack = paintBack;
        this.paintFront = paintFront;
    }

    @Override
    public void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        int lineY;
        int lineX;
        long tileLeft = MercatorProjection.longitudeToTileX(boundingBox.minLongitude, zoomLevel);
        long tileTop = MercatorProjection.latitudeToTileY(boundingBox.maxLatitude, zoomLevel);
        long tileRight = MercatorProjection.longitudeToTileX(boundingBox.maxLongitude, zoomLevel);
        long tileBottom = MercatorProjection.latitudeToTileY(boundingBox.minLatitude, zoomLevel);
        int tileSize = this.displayModel.getTileSize();
        int pixelX1 = (int)((double)MercatorProjection.tileToPixel(tileLeft, tileSize) - topLeftPoint.x);
        int pixelY1 = (int)((double)MercatorProjection.tileToPixel(tileTop, tileSize) - topLeftPoint.y);
        int pixelX2 = (int)((double)MercatorProjection.tileToPixel(tileRight, tileSize) - topLeftPoint.x + (double)tileSize);
        int pixelY2 = (int)((double)MercatorProjection.tileToPixel(tileBottom, tileSize) - topLeftPoint.y + (double)tileSize);
        for (lineX = pixelX1; lineX <= pixelX2 + 1; lineX += tileSize) {
            canvas.drawLine(lineX, pixelY1, lineX, pixelY2, this.paintBack);
        }
        for (lineY = pixelY1; lineY <= pixelY2 + 1; lineY += tileSize) {
            canvas.drawLine(pixelX1, lineY, pixelX2, lineY, this.paintBack);
        }
        for (lineX = pixelX1; lineX <= pixelX2 + 1; lineX += tileSize) {
            canvas.drawLine(lineX, pixelY1, lineX, pixelY2, this.paintFront);
        }
        for (lineY = pixelY1; lineY <= pixelY2 + 1; lineY += tileSize) {
            canvas.drawLine(pixelX1, lineY, pixelX2, lineY, this.paintFront);
        }
    }
}

