/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.download;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import org.mapsforge.core.graphics.CorruptedInputStreamException;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.util.IOUtils;
import org.mapsforge.map.layer.download.DownloadJob;

class TileDownloader {
    private static final int TIMEOUT_CONNECT = 5000;
    private static final int TIMEOUT_READ = 10000;
    private final DownloadJob downloadJob;
    private final GraphicFactory graphicFactory;

    private static InputStream getInputStream(URLConnection urlConnection) throws IOException {
        if ("gzip".equals(urlConnection.getContentEncoding())) {
            return new GZIPInputStream(urlConnection.getInputStream());
        }
        return urlConnection.getInputStream();
    }

    private static URLConnection getURLConnection(URL url) throws IOException {
        URLConnection urlConnection = url.openConnection();
        urlConnection.setConnectTimeout(5000);
        urlConnection.setReadTimeout(10000);
        return urlConnection;
    }

    TileDownloader(DownloadJob downloadJob, GraphicFactory graphicFactory) {
        if (downloadJob == null) {
            throw new IllegalArgumentException("downloadJob must not be null");
        }
        if (graphicFactory == null) {
            throw new IllegalArgumentException("graphicFactory must not be null");
        }
        this.downloadJob = downloadJob;
        this.graphicFactory = graphicFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TileBitmap downloadImage() throws IOException {
        URL url = this.downloadJob.tileSource.getTileUrl(this.downloadJob.tile);
        URLConnection urlConnection = TileDownloader.getURLConnection(url);
        InputStream inputStream = TileDownloader.getInputStream(urlConnection);
        try {
            TileBitmap result = this.graphicFactory.createTileBitmap(inputStream, this.downloadJob.tile.tileSize, this.downloadJob.hasAlpha);
            result.setExpiration(urlConnection.getExpiration());
            TileBitmap tileBitmap = result;
            return tileBitmap;
        }
        catch (CorruptedInputStreamException e) {
            TileBitmap tileBitmap = null;
            return tileBitmap;
        }
        finally {
            IOUtils.closeQuietly(inputStream);
        }
    }
}

