/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.download.tilesource;

import java.util.Arrays;
import java.util.Random;
import org.mapsforge.map.layer.download.tilesource.TileSource;

public abstract class AbstractTileSource
implements TileSource {
    protected long defaultTimeToLive = 86400000L;
    protected final String[] hostNames;
    protected final int port;
    protected final Random random = new Random();

    protected AbstractTileSource(String[] hostNames, int port) {
        if (hostNames == null || hostNames.length == 0) {
            throw new IllegalArgumentException("no host names specified");
        }
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("invalid port number: " + port);
        }
        for (String hostname : hostNames) {
            if (!hostname.isEmpty()) continue;
            throw new IllegalArgumentException("empty host name in host name list");
        }
        this.hostNames = hostNames;
        this.port = port;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractTileSource)) {
            return false;
        }
        AbstractTileSource other = (AbstractTileSource)obj;
        if (!Arrays.equals(this.hostNames, other.hostNames)) {
            return false;
        }
        return this.port == other.port;
    }

    @Override
    public long getDefaultTimeToLive() {
        return this.defaultTimeToLive;
    }

    protected String getHostName() {
        return this.hostNames[this.random.nextInt(this.hostNames.length)];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.hostNames);
        result = 31 * result + this.port;
        return result;
    }
}

