/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.labels;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.layer.labels.LabelStore;
import org.mapsforge.map.util.LayerUtil;

public class LabelLayer
extends Layer {
    private final LabelStore labelStore;
    private final Matrix matrix;
    private List<MapElementContainer> elementsToDraw;
    private Set<Tile> lastTileSet;
    private int lastLabelStoreVersion;

    public LabelLayer(GraphicFactory graphicFactory, LabelStore labelStore) {
        this.labelStore = labelStore;
        this.matrix = graphicFactory.createMatrix();
    }

    @Override
    public void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        Set<Tile> currentTileSet = LayerUtil.getTiles(boundingBox, zoomLevel, this.displayModel.getTileSize());
        if (!currentTileSet.equals(this.lastTileSet) || this.lastLabelStoreVersion != this.labelStore.getVersion()) {
            this.lastTileSet = currentTileSet;
            this.lastLabelStoreVersion = this.labelStore.getVersion();
            List<MapElementContainer> visibleItems = this.labelStore.getVisibleItems(currentTileSet);
            this.elementsToDraw = LayerUtil.collisionFreeOrdered(visibleItems);
            Collections.sort(this.elementsToDraw);
        }
        for (MapElementContainer item : this.elementsToDraw) {
            item.draw(canvas, topLeftPoint, this.matrix);
        }
    }
}

