/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.labels;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.WorkingSetCache;
import org.mapsforge.map.layer.labels.LabelStore;
import org.mapsforge.map.util.LayerUtil;

public class TileBasedLabelStore
extends WorkingSetCache<Tile, List<MapElementContainer>>
implements LabelStore {
    private static final long serialVersionUID = 1L;
    private Set<Tile> lastVisibleTileSet = new HashSet<Tile>();
    private int version;

    public TileBasedLabelStore(int capacity) {
        super(capacity);
    }

    public void destroy() {
        this.clear();
    }

    public synchronized void storeMapItems(Tile tile, List<MapElementContainer> mapItems) {
        this.put(tile, LayerUtil.collisionFreeOrdered(mapItems));
        ++this.version;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public synchronized List<MapElementContainer> getVisibleItems(Set<Tile> tiles) {
        this.lastVisibleTileSet = tiles;
        ArrayList<MapElementContainer> visibleItems = new ArrayList<MapElementContainer>();
        for (Tile tile : this.lastVisibleTileSet) {
            if (!this.containsKey(tile)) continue;
            visibleItems.addAll((Collection)this.get(tile));
        }
        return visibleItems;
    }

    public synchronized boolean requiresTile(Tile tile) {
        return this.lastVisibleTileSet.contains(tile) && !this.containsKey(tile);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Tile, List<MapElementContainer>> eldest) {
        return this.size() > this.capacity;
    }
}

