/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.overlay;

import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.Layer;

public class Circle
extends Layer {
    private final boolean keepAligned;
    private LatLong latLong;
    private Paint paintFill;
    private Paint paintStroke;
    private float radius;

    public Circle(LatLong latLong, float radius, Paint paintFill, Paint paintStroke) {
        this(latLong, radius, paintFill, paintStroke, false);
    }

    public Circle(LatLong latLong, float radius, Paint paintFill, Paint paintStroke, boolean keepAligned) {
        this.keepAligned = keepAligned;
        this.latLong = latLong;
        this.setRadiusInternal(radius);
        this.paintFill = paintFill;
        this.paintStroke = paintStroke;
    }

    @Override
    public synchronized void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        if (this.latLong == null || this.paintStroke == null && this.paintFill == null) {
            return;
        }
        double latitude = this.latLong.latitude;
        double longitude = this.latLong.longitude;
        long mapSize = MercatorProjection.getMapSize(zoomLevel, this.displayModel.getTileSize());
        int pixelX = (int)(MercatorProjection.longitudeToPixelX(longitude, mapSize) - topLeftPoint.x);
        int pixelY = (int)(MercatorProjection.latitudeToPixelY(latitude, mapSize) - topLeftPoint.y);
        int radiusInPixel = this.getRadiusInPixels(latitude, zoomLevel);
        Rectangle canvasRectangle = new Rectangle(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        if (!canvasRectangle.intersectsCircle(pixelX, pixelY, radiusInPixel)) {
            return;
        }
        if (this.paintStroke != null) {
            if (this.keepAligned) {
                this.paintStroke.setBitmapShaderShift(topLeftPoint);
            }
            canvas.drawCircle(pixelX, pixelY, radiusInPixel, this.paintStroke);
        }
        if (this.paintFill != null) {
            if (this.keepAligned) {
                this.paintFill.setBitmapShaderShift(topLeftPoint);
            }
            canvas.drawCircle(pixelX, pixelY, radiusInPixel, this.paintFill);
        }
    }

    public synchronized Paint getPaintFill() {
        return this.paintFill;
    }

    public synchronized Paint getPaintStroke() {
        return this.paintStroke;
    }

    @Override
    public synchronized LatLong getPosition() {
        return this.latLong;
    }

    public synchronized float getRadius() {
        return this.radius;
    }

    protected int getRadiusInPixels(double latitude, byte zoomLevel) {
        return (int)MercatorProjection.metersToPixels(this.radius, latitude, MercatorProjection.getMapSize(zoomLevel, this.displayModel.getTileSize()));
    }

    public boolean isKeepAligned() {
        return this.keepAligned;
    }

    public synchronized void setLatLong(LatLong latLong) {
        this.latLong = latLong;
    }

    public synchronized void setPaintFill(Paint paintFill) {
        this.paintFill = paintFill;
    }

    public synchronized void setPaintStroke(Paint paintStroke) {
        this.paintStroke = paintStroke;
    }

    public synchronized void setRadius(float radius) {
        this.setRadiusInternal(radius);
    }

    private void setRadiusInternal(float radius) {
        if (radius < 0.0f || Float.isNaN(radius)) {
            throw new IllegalArgumentException("invalid radius: " + radius);
        }
        this.radius = radius;
    }
}

