/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.overlay;

import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.Layer;

public class Marker
extends Layer {
    private Bitmap bitmap;
    private int horizontalOffset;
    private LatLong latLong;
    private int verticalOffset;

    public Marker(LatLong latLong, Bitmap bitmap, int horizontalOffset, int verticalOffset) {
        this.latLong = latLong;
        this.bitmap = bitmap;
        this.horizontalOffset = horizontalOffset;
        this.verticalOffset = verticalOffset;
    }

    public synchronized boolean contains(Point center, Point point) {
        Rectangle r = new Rectangle(center.x - (double)((float)this.bitmap.getWidth() / 2.0f) + (double)this.horizontalOffset, center.y - (double)((float)this.bitmap.getHeight() / 2.0f) + (double)this.verticalOffset, center.x + (double)((float)this.bitmap.getWidth() / 2.0f) + (double)this.horizontalOffset, center.y + (double)((float)this.bitmap.getHeight() / 2.0f) + (double)this.verticalOffset);
        return r.contains(point);
    }

    @Override
    public synchronized void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        if (this.latLong == null || this.bitmap == null) {
            return;
        }
        long mapSize = MercatorProjection.getMapSize(zoomLevel, this.displayModel.getTileSize());
        double pixelX = MercatorProjection.longitudeToPixelX(this.latLong.longitude, mapSize);
        double pixelY = MercatorProjection.latitudeToPixelY(this.latLong.latitude, mapSize);
        int halfBitmapWidth = this.bitmap.getWidth() / 2;
        int halfBitmapHeight = this.bitmap.getHeight() / 2;
        int left = (int)(pixelX - topLeftPoint.x - (double)halfBitmapWidth + (double)this.horizontalOffset);
        int top = (int)(pixelY - topLeftPoint.y - (double)halfBitmapHeight + (double)this.verticalOffset);
        int right = left + this.bitmap.getWidth();
        int bottom = top + this.bitmap.getHeight();
        Rectangle bitmapRectangle = new Rectangle(left, top, right, bottom);
        Rectangle canvasRectangle = new Rectangle(0.0, 0.0, canvas.getWidth(), canvas.getHeight());
        if (!canvasRectangle.intersects(bitmapRectangle)) {
            return;
        }
        canvas.drawBitmap(this.bitmap, left, top);
    }

    public synchronized Bitmap getBitmap() {
        return this.bitmap;
    }

    public synchronized int getHorizontalOffset() {
        return this.horizontalOffset;
    }

    public synchronized LatLong getLatLong() {
        return this.latLong;
    }

    @Override
    public synchronized LatLong getPosition() {
        return this.latLong;
    }

    public synchronized int getVerticalOffset() {
        return this.verticalOffset;
    }

    @Override
    public synchronized void onDestroy() {
        if (this.bitmap != null) {
            this.bitmap.decrementRefCount();
        }
    }

    public synchronized void setBitmap(Bitmap bitmap) {
        if (this.bitmap != null && this.bitmap.equals(bitmap)) {
            return;
        }
        if (this.bitmap != null) {
            this.bitmap.decrementRefCount();
        }
        this.bitmap = bitmap;
    }

    public synchronized void setHorizontalOffset(int horizontalOffset) {
        this.horizontalOffset = horizontalOffset;
    }

    public synchronized void setLatLong(LatLong latLong) {
        this.latLong = latLong;
    }

    public synchronized void setVerticalOffset(int verticalOffset) {
        this.verticalOffset = verticalOffset;
    }
}

