/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.overlay;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Path;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.Layer;

public class Polygon
extends Layer {
    private final GraphicFactory graphicFactory;
    private final boolean keepAligned;
    private final List<LatLong> latLongs = new CopyOnWriteArrayList<LatLong>();
    private Paint paintFill;
    private Paint paintStroke;

    public Polygon(Paint paintFill, Paint paintStroke, GraphicFactory graphicFactory) {
        this(paintFill, paintStroke, graphicFactory, false);
    }

    public Polygon(Paint paintFill, Paint paintStroke, GraphicFactory graphicFactory, boolean keepAligned) {
        this.keepAligned = keepAligned;
        this.paintFill = paintFill;
        this.paintStroke = paintStroke;
        this.graphicFactory = graphicFactory;
    }

    @Override
    public synchronized void draw(BoundingBox boundingBox, byte zoomLevel, Canvas canvas, Point topLeftPoint) {
        if (this.latLongs.size() < 2 || this.paintStroke == null && this.paintFill == null) {
            return;
        }
        Iterator<LatLong> iterator = this.latLongs.iterator();
        Path path = this.graphicFactory.createPath();
        LatLong latLong = iterator.next();
        long mapSize = MercatorProjection.getMapSize(zoomLevel, this.displayModel.getTileSize());
        float x = (float)(MercatorProjection.longitudeToPixelX(latLong.longitude, mapSize) - topLeftPoint.x);
        float y = (float)(MercatorProjection.latitudeToPixelY(latLong.latitude, mapSize) - topLeftPoint.y);
        path.moveTo(x, y);
        while (iterator.hasNext()) {
            latLong = iterator.next();
            x = (float)(MercatorProjection.longitudeToPixelX(latLong.longitude, mapSize) - topLeftPoint.x);
            y = (float)(MercatorProjection.latitudeToPixelY(latLong.latitude, mapSize) - topLeftPoint.y);
            path.lineTo(x, y);
        }
        if (this.paintStroke != null) {
            if (this.keepAligned) {
                this.paintStroke.setBitmapShaderShift(topLeftPoint);
            }
            canvas.drawPath(path, this.paintStroke);
        }
        if (this.paintFill != null) {
            if (this.keepAligned) {
                this.paintFill.setBitmapShaderShift(topLeftPoint);
            }
            canvas.drawPath(path, this.paintFill);
        }
    }

    public List<LatLong> getLatLongs() {
        return this.latLongs;
    }

    public synchronized Paint getPaintFill() {
        return this.paintFill;
    }

    public synchronized Paint getPaintStroke() {
        return this.paintStroke;
    }

    public boolean isKeepAligned() {
        return this.keepAligned;
    }

    public synchronized void setPaintFill(Paint paintFill) {
        this.paintFill = paintFill;
    }

    public synchronized void setPaintStroke(Paint paintStroke) {
        this.paintStroke = paintStroke;
    }
}

