/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.queue;

import java.io.File;
import org.mapsforge.core.model.Tile;

public class Job {
    public final boolean hasAlpha;
    public final Tile tile;
    private final String key;

    private static String composeKey(byte z, long x, long y) {
        return String.valueOf(z) + File.separatorChar + x + File.separatorChar + y;
    }

    public static String composeKey(String z, String x, String y) {
        return z + File.separatorChar + x + File.separatorChar + y;
    }

    public Job(Tile tile, boolean hasAlpha) {
        if (tile == null) {
            throw new IllegalArgumentException("tile must not be null");
        }
        this.tile = tile;
        this.hasAlpha = hasAlpha;
        this.key = Job.composeKey(this.tile.zoomLevel, this.tile.tileX, this.tile.tileY);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Job)) {
            return false;
        }
        Job other = (Job)obj;
        return this.hasAlpha == other.hasAlpha && this.tile.equals(other.tile);
    }

    public String getKey() {
        return this.key;
    }

    public int hashCode() {
        return this.tile.hashCode();
    }
}

