/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.queue;

import java.util.Collection;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.queue.Job;
import org.mapsforge.map.layer.queue.QueueItem;

final class QueueItemScheduler {
    static final double PENALTY_PER_ZOOM_LEVEL = 10.0;

    static <T extends Job> void schedule(Collection<QueueItem<T>> queueItems, MapPosition mapPosition, int tileSize) {
        for (QueueItem<T> queueItem : queueItems) {
            queueItem.setPriority(QueueItemScheduler.calculatePriority(((Job)queueItem.object).tile, mapPosition, tileSize));
        }
    }

    private static double calculatePriority(Tile tile, MapPosition mapPosition, int tileSize) {
        double tileLatitude = MercatorProjection.tileYToLatitude((long)tile.tileY, tile.zoomLevel);
        double tileLongitude = MercatorProjection.tileXToLongitude((long)tile.tileX, tile.zoomLevel);
        int halfTileSize = tileSize / 2;
        long mapSize = MercatorProjection.getMapSize(mapPosition.zoomLevel, tileSize);
        double tilePixelX = MercatorProjection.longitudeToPixelX(tileLongitude, mapSize) + (double)halfTileSize;
        double tilePixelY = MercatorProjection.latitudeToPixelY(tileLatitude, mapSize) + (double)halfTileSize;
        LatLong latLong = mapPosition.latLong;
        double mapPixelX = MercatorProjection.longitudeToPixelX(latLong.longitude, mapSize);
        double mapPixelY = MercatorProjection.latitudeToPixelY(latLong.latitude, mapSize);
        double diffPixel = Math.hypot(tilePixelX - mapPixelX, tilePixelY - mapPixelY);
        int diffZoom = Math.abs(tile.zoomLevel - mapPosition.zoomLevel);
        return diffPixel + 10.0 * (double)tileSize * (double)diffZoom;
    }

    private QueueItemScheduler() {
        throw new IllegalStateException();
    }
}

