/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Position;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.mapelements.SymbolContainer;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tag;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.datastore.MapReadResult;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.datastore.Way;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.labels.TileBasedLabelStore;
import org.mapsforge.map.layer.renderer.CanvasRasterer;
import org.mapsforge.map.layer.renderer.CircleContainer;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.layer.renderer.RendererJob;
import org.mapsforge.map.layer.renderer.ShapePaintContainer;
import org.mapsforge.map.layer.renderer.TileDependencies;
import org.mapsforge.map.layer.renderer.WayDecorator;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.rule.RenderTheme;
import org.mapsforge.map.util.LayerUtil;

public class DatabaseRenderer
implements RenderCallback {
    private static final Byte DEFAULT_START_ZOOM_LEVEL = 12;
    private static final Logger LOGGER = Logger.getLogger(DatabaseRenderer.class.getName());
    private static final Tag TAG_NATURAL_WATER = new Tag("natural", "water");
    private static final byte ZOOM_MAX = 22;
    private final GraphicFactory graphicFactory;
    private final TileBasedLabelStore labelStore;
    private final MapDataStore mapDatabase;
    private final boolean renderLabels;
    private final TileCache tileCache;
    private final TileDependencies tileDependencies;

    private static Point[] getTilePixelCoordinates(int tileSize) {
        Point[] result;
        result = new Point[]{new Point(0.0, 0.0), new Point(tileSize, 0.0), new Point(tileSize, tileSize), new Point(0.0, tileSize), result[0]};
        return result;
    }

    public DatabaseRenderer(MapDataStore mapDatabase, GraphicFactory graphicFactory, TileBasedLabelStore labelStore) {
        this.mapDatabase = mapDatabase;
        this.graphicFactory = graphicFactory;
        this.labelStore = labelStore;
        this.renderLabels = false;
        this.tileCache = null;
        this.tileDependencies = null;
    }

    public DatabaseRenderer(MapDataStore mapFile, GraphicFactory graphicFactory, TileCache tileCache) {
        this.mapDatabase = mapFile;
        this.graphicFactory = graphicFactory;
        this.labelStore = null;
        this.renderLabels = true;
        this.tileCache = tileCache;
        this.tileDependencies = new TileDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileBitmap executeJob(RendererJob rendererJob) {
        RenderTheme renderTheme;
        try {
            renderTheme = (RenderTheme)rendererJob.renderThemeFuture.get();
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error to retrieve render theme from future", e);
            return null;
        }
        RenderContext renderContext = null;
        try {
            renderContext = new RenderContext(renderTheme, rendererJob, new CanvasRasterer(this.graphicFactory));
            if (this.renderBitmap(renderContext)) {
                TileBitmap bitmap = null;
                if (this.mapDatabase != null) {
                    MapReadResult mapReadResult = this.mapDatabase.readMapData(rendererJob.tile);
                    this.processReadMapData(renderContext, mapReadResult);
                }
                if (!rendererJob.labelsOnly) {
                    bitmap = this.graphicFactory.createTileBitmap(renderContext.rendererJob.tile.tileSize, renderContext.rendererJob.hasAlpha);
                    bitmap.setTimestamp(rendererJob.mapDataStore.getDataTimestamp(renderContext.rendererJob.tile));
                    renderContext.canvasRasterer.setCanvasBitmap(bitmap);
                    if (!rendererJob.hasAlpha && rendererJob.displayModel.getBackgroundColor() != renderContext.renderTheme.getMapBackground()) {
                        renderContext.canvasRasterer.fill(renderContext.renderTheme.getMapBackground());
                    }
                    renderContext.canvasRasterer.drawWays(renderContext);
                }
                if (this.renderLabels) {
                    Set<MapElementContainer> labelsToDraw = this.processLabels(renderContext);
                    renderContext.canvasRasterer.drawMapElements(labelsToDraw, renderContext.rendererJob.tile);
                } else {
                    this.labelStore.storeMapItems(renderContext.rendererJob.tile, renderContext.labels);
                }
                if (!rendererJob.labelsOnly && renderContext.renderTheme.hasMapBackgroundOutside()) {
                    Rectangle insideArea = this.mapDatabase.boundingBox().getPositionRelativeToTile(renderContext.rendererJob.tile);
                    if (!rendererJob.hasAlpha) {
                        renderContext.canvasRasterer.fillOutsideAreas(renderContext.renderTheme.getMapBackgroundOutside(), insideArea);
                    } else {
                        renderContext.canvasRasterer.fillOutsideAreas(Color.TRANSPARENT, insideArea);
                    }
                }
                TileBitmap tileBitmap = bitmap;
                return tileBitmap;
            }
            TileBitmap tileBitmap = this.createBackgroundBitmap(renderContext);
            return tileBitmap;
        }
        finally {
            if (renderContext != null) {
                renderContext.destroy();
            }
        }
    }

    public MapDataStore getMapDatabase() {
        return this.mapDatabase;
    }

    public LatLong getStartPosition() {
        if (this.mapDatabase != null) {
            return this.mapDatabase.startPosition();
        }
        return null;
    }

    public Byte getStartZoomLevel() {
        if (this.mapDatabase != null && null != this.mapDatabase.startZoomLevel()) {
            return this.mapDatabase.startZoomLevel();
        }
        return DEFAULT_START_ZOOM_LEVEL;
    }

    public byte getZoomLevelMax() {
        return 22;
    }

    void removeTileInProgress(Tile tile) {
        if (this.tileDependencies != null) {
            this.tileDependencies.removeTileInProgress(tile);
        }
    }

    @Override
    public void renderArea(RenderContext renderContext, Paint fill, Paint stroke, int level, PolylineContainer way) {
        renderContext.addToCurrentDrawingLayer(level, new ShapePaintContainer(way, stroke));
        renderContext.addToCurrentDrawingLayer(level, new ShapePaintContainer(way, fill));
    }

    @Override
    public void renderAreaCaption(RenderContext renderContext, Display display, int priority, String caption, float horizontalOffset, float verticalOffset, Paint fill, Paint stroke, Position position, int maxTextWidth, PolylineContainer way) {
        Point centerPoint = way.getCenterAbsolute().offset(horizontalOffset, verticalOffset);
        renderContext.labels.add(this.graphicFactory.createPointTextContainer(centerPoint, display, priority, caption, fill, stroke, null, position, maxTextWidth));
    }

    @Override
    public void renderAreaSymbol(RenderContext renderContext, Display display, int priority, Bitmap symbol, PolylineContainer way) {
        Point centerPosition = way.getCenterAbsolute();
        renderContext.labels.add(new SymbolContainer(centerPosition, display, priority, symbol));
    }

    @Override
    public void renderPointOfInterestCaption(RenderContext renderContext, Display display, int priority, String caption, float horizontalOffset, float verticalOffset, Paint fill, Paint stroke, Position position, int maxTextWidth, PointOfInterest poi) {
        Point poiPosition = MercatorProjection.getPixelAbsolute(poi.position, renderContext.rendererJob.tile.mapSize);
        renderContext.labels.add(this.graphicFactory.createPointTextContainer(poiPosition.offset(horizontalOffset, verticalOffset), display, priority, caption, fill, stroke, null, position, maxTextWidth));
    }

    @Override
    public void renderPointOfInterestCircle(RenderContext renderContext, float radius, Paint fill, Paint stroke, int level, PointOfInterest poi) {
        Point poiPosition = MercatorProjection.getPixelRelativeToTile(poi.position, renderContext.rendererJob.tile);
        renderContext.addToCurrentDrawingLayer(level, new ShapePaintContainer(new CircleContainer(poiPosition, radius), stroke));
        renderContext.addToCurrentDrawingLayer(level, new ShapePaintContainer(new CircleContainer(poiPosition, radius), fill));
    }

    @Override
    public void renderPointOfInterestSymbol(RenderContext renderContext, Display display, int priority, Bitmap symbol, PointOfInterest poi) {
        Point poiPosition = MercatorProjection.getPixelAbsolute(poi.position, renderContext.rendererJob.tile.mapSize);
        renderContext.labels.add(new SymbolContainer(poiPosition, display, priority, symbol));
    }

    @Override
    public void renderWay(RenderContext renderContext, Paint stroke, float dy, int level, PolylineContainer way) {
        renderContext.addToCurrentDrawingLayer(level, new ShapePaintContainer(way, stroke, dy));
    }

    @Override
    public void renderWaySymbol(RenderContext renderContext, Display display, int priority, Bitmap symbol, float dy, boolean alignCenter, boolean repeat, float repeatGap, float repeatStart, boolean rotate, PolylineContainer way) {
        WayDecorator.renderSymbol(symbol, display, priority, dy, alignCenter, repeat, repeatGap, repeatStart, rotate, way.getCoordinatesAbsolute(), renderContext.labels);
    }

    @Override
    public void renderWayText(RenderContext renderContext, Display display, int priority, String textKey, float dy, Paint fill, Paint stroke, PolylineContainer way) {
        WayDecorator.renderText(way.getTile(), textKey, display, priority, dy, fill, stroke, way.getCoordinatesAbsolute(), renderContext.labels);
    }

    boolean renderBitmap(RenderContext renderContext) {
        return !renderContext.renderTheme.hasMapBackgroundOutside() || this.mapDatabase.supportsTile(renderContext.rendererJob.tile);
    }

    private TileBitmap createBackgroundBitmap(RenderContext renderContext) {
        TileBitmap bitmap = this.graphicFactory.createTileBitmap(renderContext.rendererJob.tile.tileSize, renderContext.rendererJob.hasAlpha);
        renderContext.canvasRasterer.setCanvasBitmap(bitmap);
        if (!renderContext.rendererJob.hasAlpha) {
            renderContext.canvasRasterer.fill(renderContext.renderTheme.getMapBackgroundOutside());
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MapElementContainer> processLabels(RenderContext renderContext) {
        HashSet<MapElementContainer> labelsToDraw = new HashSet<MapElementContainer>();
        TileDependencies tileDependencies = this.tileDependencies;
        synchronized (tileDependencies) {
            Set<Tile> neighbours = renderContext.rendererJob.tile.getNeighbours();
            Iterator<Tile> tileIterator = neighbours.iterator();
            HashSet<MapElementContainer> undrawableElements = new HashSet<MapElementContainer>();
            this.tileDependencies.addTileInProgress(renderContext.rendererJob.tile);
            while (tileIterator.hasNext()) {
                Tile neighbour = tileIterator.next();
                if (this.tileDependencies.isTileInProgress(neighbour) || this.tileCache.containsKey(renderContext.rendererJob.otherTile(neighbour))) {
                    labelsToDraw.addAll(this.tileDependencies.getOverlappingElements(neighbour, renderContext.rendererJob.tile));
                    for (MapElementContainer current : renderContext.labels) {
                        if (!current.intersects(neighbour.getBoundaryAbsolute())) continue;
                        undrawableElements.add(current);
                    }
                    tileIterator.remove();
                    continue;
                }
                this.tileDependencies.removeTileData(neighbour);
            }
            renderContext.labels.removeAll(undrawableElements);
            List<MapElementContainer> currentElementsOrdered = LayerUtil.collisionFreeOrdered(renderContext.labels);
            Iterator<MapElementContainer> currentMapElementsIterator = currentElementsOrdered.iterator();
            block5: while (currentMapElementsIterator.hasNext()) {
                MapElementContainer current;
                current = currentMapElementsIterator.next();
                for (MapElementContainer label : labelsToDraw) {
                    if (!label.clashesWith(current)) continue;
                    currentMapElementsIterator.remove();
                    continue block5;
                }
            }
            labelsToDraw.addAll(currentElementsOrdered);
            for (Tile tile : neighbours) {
                this.tileDependencies.removeTileData(renderContext.rendererJob.tile, tile);
                for (MapElementContainer element : labelsToDraw) {
                    if (!element.intersects(tile.getBoundaryAbsolute())) continue;
                    this.tileDependencies.addOverlappingElement(renderContext.rendererJob.tile, tile, element);
                }
            }
        }
        return labelsToDraw;
    }

    private void processReadMapData(RenderContext renderContext, MapReadResult mapReadResult) {
        if (mapReadResult == null) {
            return;
        }
        for (PointOfInterest pointOfInterest : mapReadResult.pointOfInterests) {
            this.renderPointOfInterest(renderContext, pointOfInterest);
        }
        for (Way way : mapReadResult.ways) {
            this.renderWay(renderContext, new PolylineContainer(way, renderContext.rendererJob.tile));
        }
        if (mapReadResult.isWater) {
            this.renderWaterBackground(renderContext);
        }
    }

    private void renderPointOfInterest(RenderContext renderContext, PointOfInterest pointOfInterest) {
        renderContext.setDrawingLayers(pointOfInterest.layer);
        renderContext.renderTheme.matchNode(this, renderContext, pointOfInterest);
    }

    private void renderWaterBackground(RenderContext renderContext) {
        renderContext.setDrawingLayers((byte)0);
        Point[] coordinates = DatabaseRenderer.getTilePixelCoordinates(renderContext.rendererJob.tile.tileSize);
        PolylineContainer way = new PolylineContainer(coordinates, renderContext.rendererJob.tile, Arrays.asList(TAG_NATURAL_WATER));
        renderContext.renderTheme.matchClosedWay(this, renderContext, way);
    }

    private void renderWay(RenderContext renderContext, PolylineContainer way) {
        renderContext.setDrawingLayers(way.getLayer());
        if (way.isClosedWay()) {
            renderContext.renderTheme.matchClosedWay(this, renderContext, way);
        } else {
            renderContext.renderTheme.matchLinearWay(this, renderContext, way);
        }
    }
}

