/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import org.mapsforge.core.model.Tile;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.layer.queue.Job;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.rule.RenderThemeFuture;

public class RendererJob
extends Job {
    public final DisplayModel displayModel;
    public boolean labelsOnly;
    public final MapDataStore mapDataStore;
    public final RenderThemeFuture renderThemeFuture;
    public final float textScale;
    private final int hashCodeValue;

    public RendererJob(Tile tile, MapDataStore mapFile, RenderThemeFuture renderThemeFuture, DisplayModel displayModel, float textScale, boolean isTransparent, boolean labelsOnly) {
        super(tile, isTransparent);
        if (mapFile == null) {
            throw new IllegalArgumentException("mapFile must not be null");
        }
        if (textScale <= 0.0f || Float.isNaN(textScale)) {
            throw new IllegalArgumentException("invalid textScale: " + textScale);
        }
        this.labelsOnly = labelsOnly;
        this.displayModel = displayModel;
        this.mapDataStore = mapFile;
        this.renderThemeFuture = renderThemeFuture;
        this.textScale = textScale;
        this.hashCodeValue = this.calculateHashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RendererJob)) {
            return false;
        }
        RendererJob other = (RendererJob)obj;
        if (!this.mapDataStore.equals(other.mapDataStore)) {
            return false;
        }
        if (Float.floatToIntBits(this.textScale) != Float.floatToIntBits(other.textScale)) {
            return false;
        }
        if (this.renderThemeFuture == null && other.renderThemeFuture != null) {
            return false;
        }
        if (this.renderThemeFuture != null && !this.renderThemeFuture.equals(other.renderThemeFuture)) {
            return false;
        }
        if (this.labelsOnly != other.labelsOnly) {
            return false;
        }
        return this.displayModel.equals(other.displayModel);
    }

    @Override
    public int hashCode() {
        return this.hashCodeValue;
    }

    public RendererJob otherTile(Tile tile) {
        return new RendererJob(tile, this.mapDataStore, this.renderThemeFuture, this.displayModel, this.textScale, this.hasAlpha, this.labelsOnly);
    }

    public void setRetrieveLabelsOnly() {
        this.labelsOnly = true;
    }

    private int calculateHashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.mapDataStore.hashCode();
        result = 31 * result + Float.floatToIntBits(this.textScale);
        if (this.renderThemeFuture != null) {
            result = 31 * result + this.renderThemeFuture.hashCode();
        }
        return result;
    }
}

