/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.List;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.mapelements.SymbolContainer;
import org.mapsforge.core.mapelements.WayTextContainer;
import org.mapsforge.core.model.LineSegment;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.renderer.RendererUtils;

final class WayDecorator {
    private static final int WAYNAME_SAFETY_MARGIN = 10;

    static void renderSymbol(Bitmap symbolBitmap, Display display, int priority, float dy, boolean alignCenter, boolean repeatSymbol, float repeatGap, float repeatStart, boolean rotate, Point[][] coordinates, List<MapElementContainer> currentItems) {
        int skipPixels = (int)repeatStart;
        Point[] c = dy == 0.0f ? coordinates[0] : RendererUtils.parallelPath(coordinates[0], dy);
        double previousX = c[0].x;
        double previousY = c[0].y;
        float theta = 0.0f;
        for (int i = 1; i < c.length; ++i) {
            double currentX = c[i].x;
            double currentY = c[i].y;
            double diffX = currentX - previousX;
            double diffY = currentY - previousY;
            double segmentLengthInPixel = Math.sqrt(diffX * diffX + diffY * diffY);
            float segmentLengthRemaining = (float)segmentLengthInPixel;
            while (segmentLengthRemaining - (float)skipPixels > repeatStart) {
                float segmentSkipPercentage = (float)skipPixels / segmentLengthRemaining;
                previousX += diffX * (double)segmentSkipPercentage;
                previousY += diffY * (double)segmentSkipPercentage;
                if (rotate) {
                    theta = (float)Math.atan2(currentY - previousY, currentX - previousX);
                }
                Point point = new Point(previousX, previousY);
                currentItems.add(new SymbolContainer(point, display, priority, symbolBitmap, theta, alignCenter));
                if (!repeatSymbol) {
                    return;
                }
                diffX = currentX - previousX;
                diffY = currentY - previousY;
                segmentLengthRemaining -= (float)skipPixels;
                skipPixels = (int)repeatGap;
            }
            if ((float)(skipPixels = (int)((float)skipPixels - segmentLengthRemaining)) < repeatStart) {
                skipPixels = (int)repeatStart;
            }
            previousX = currentX;
            previousY = currentY;
        }
    }

    static void renderText(Tile tile, String text, Display display, int priority, float dy, Paint fill, Paint stroke, Point[][] coordinates, List<MapElementContainer> currentLabels) {
        int wayNameWidth = stroke == null ? fill.getTextWidth(text) + 20 : stroke.getTextWidth(text) + 20;
        double textHeight = stroke == null ? (double)fill.getTextHeight(text) : (double)stroke.getTextHeight(text);
        Rectangle tileBoundary = tile.getBoundaryAbsolute().envelope(-textHeight);
        int skipPixels = 0;
        Point[] c = dy == 0.0f ? coordinates[0] : RendererUtils.parallelPath(coordinates[0], dy);
        for (int i = 1; i < c.length; ++i) {
            double segmentLengthInPixel;
            LineSegment drawableSegment;
            LineSegment currentSegment = new LineSegment(c[i - 1], c[i]);
            double currentLength = currentSegment.length();
            if ((skipPixels = (int)((double)skipPixels - currentLength)) > 0 || currentLength < (double)wayNameWidth || (drawableSegment = currentSegment.clipToRectangle(tileBoundary)) == null || (segmentLengthInPixel = drawableSegment.length()) < (double)wayNameWidth) continue;
            LineSegment actuallyUsedSegment = drawableSegment.subSegment(10.0, wayNameWidth - 10);
            if (actuallyUsedSegment.start.x <= actuallyUsedSegment.end.x) {
                currentLabels.add(new WayTextContainer(actuallyUsedSegment.start, actuallyUsedSegment.end, display, priority, text, fill, stroke, textHeight));
            } else {
                currentLabels.add(new WayTextContainer(actuallyUsedSegment.end, actuallyUsedSegment.start, display, priority, text, fill, stroke, textHeight));
            }
            skipPixels = wayNameWidth;
        }
    }

    private WayDecorator() {
        throw new IllegalStateException();
    }
}

