/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.model;

import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.common.Observable;
import org.mapsforge.map.model.common.Persistable;
import org.mapsforge.map.model.common.PreferencesFacade;
import org.mapsforge.map.util.PausableThread;

public class MapViewPosition
extends Observable
implements Persistable {
    private static final String LATITUDE = "latitude";
    private static final String LATITUDE_MAX = "latitudeMax";
    private static final String LATITUDE_MIN = "latitudeMin";
    private static final String LONGITUDE = "longitude";
    private static final String LONGITUDE_MAX = "longitudeMax";
    private static final String LONGITUDE_MIN = "longitudeMin";
    private static final String ZOOM_LEVEL = "zoomLevel";
    private static final String ZOOM_LEVEL_MAX = "zoomLevelMax";
    private static final String ZOOM_LEVEL_MIN = "zoomLevelMin";
    private final DisplayModel displayModel;
    private double latitude;
    private double longitude;
    private BoundingBox mapLimit;
    private LatLong pivot;
    private double scaleFactor;
    private final ZoomAnimator zoomAnimator;
    private byte zoomLevel;
    private byte zoomLevelMax;
    private byte zoomLevelMin;

    private static boolean isNan(double ... values) {
        for (double value : values) {
            if (!Double.isNaN(value)) continue;
            return true;
        }
        return false;
    }

    public MapViewPosition(DisplayModel displayModel) {
        this.displayModel = displayModel;
        this.zoomLevelMax = (byte)127;
        this.zoomAnimator = new ZoomAnimator();
        this.zoomAnimator.start();
    }

    public void animateTo(final LatLong pos) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                int totalSteps = 25;
                int signX = 1;
                int signY = 1;
                long mapSize = MercatorProjection.getMapSize(MapViewPosition.this.getZoomLevel(), MapViewPosition.this.displayModel.getTileSize());
                double targetPixelX = MercatorProjection.longitudeToPixelX(pos.longitude, mapSize);
                double targetPixelY = MercatorProjection.latitudeToPixelY(pos.latitude, mapSize);
                double currentPixelX = MercatorProjection.longitudeToPixelX(MapViewPosition.this.longitude, mapSize);
                double currentPixelY = MercatorProjection.latitudeToPixelY(MapViewPosition.this.latitude, mapSize);
                double stepSizeX = Math.abs(targetPixelX - currentPixelX) / (double)totalSteps;
                double stepSizeY = Math.abs(targetPixelY - currentPixelY) / (double)totalSteps;
                if (currentPixelX < targetPixelX) {
                    signX = -1;
                }
                if (currentPixelY < targetPixelY) {
                    signY = -1;
                }
                for (int i = 0; i < totalSteps; ++i) {
                    MapViewPosition.this.moveCenter(stepSizeX * (double)signX, stepSizeY * (double)signY);
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }).start();
    }

    public boolean animationInProgress() {
        return this.scaleFactor != MercatorProjection.zoomLevelToScaleFactor(this.zoomLevel);
    }

    public void destroy() {
        this.zoomAnimator.interrupt();
    }

    public synchronized LatLong getCenter() {
        return new LatLong(this.latitude, this.longitude);
    }

    public synchronized BoundingBox getMapLimit() {
        return this.mapLimit;
    }

    public synchronized MapPosition getMapPosition() {
        return new MapPosition(this.getCenter(), this.zoomLevel);
    }

    public synchronized LatLong getPivot() {
        return this.pivot;
    }

    public synchronized Point getPivotXY(byte zoomLevel) {
        if (this.pivot != null) {
            return MercatorProjection.getPixel(this.pivot, MercatorProjection.getMapSize(zoomLevel, this.displayModel.getTileSize()));
        }
        return null;
    }

    public synchronized double getScaleFactor() {
        return this.scaleFactor;
    }

    public synchronized byte getZoomLevel() {
        return this.zoomLevel;
    }

    public synchronized byte getZoomLevelMax() {
        return this.zoomLevelMax;
    }

    public synchronized byte getZoomLevelMin() {
        return this.zoomLevelMin;
    }

    @Override
    public synchronized void init(PreferencesFacade preferencesFacade) {
        this.latitude = preferencesFacade.getDouble(LATITUDE, 0.0);
        this.longitude = preferencesFacade.getDouble(LONGITUDE, 0.0);
        double maxLatitude = preferencesFacade.getDouble(LATITUDE_MAX, Double.NaN);
        double minLatitude = preferencesFacade.getDouble(LATITUDE_MIN, Double.NaN);
        double maxLongitude = preferencesFacade.getDouble(LONGITUDE_MAX, Double.NaN);
        double minLongitude = preferencesFacade.getDouble(LONGITUDE_MIN, Double.NaN);
        this.mapLimit = MapViewPosition.isNan(maxLatitude, minLatitude, maxLongitude, minLongitude) ? null : new BoundingBox(minLatitude, minLongitude, maxLatitude, maxLongitude);
        this.zoomLevel = preferencesFacade.getByte(ZOOM_LEVEL, (byte)0);
        this.zoomLevelMax = preferencesFacade.getByte(ZOOM_LEVEL_MAX, (byte)127);
        this.zoomLevelMin = preferencesFacade.getByte(ZOOM_LEVEL_MIN, (byte)0);
        this.scaleFactor = Math.pow(2.0, this.zoomLevel);
    }

    public void moveCenter(double moveHorizontal, double moveVertical) {
        this.moveCenterAndZoom(moveHorizontal, moveVertical, (byte)0, true);
    }

    public void moveCenter(double moveHorizontal, double moveVertical, boolean animated) {
        this.moveCenterAndZoom(moveHorizontal, moveVertical, (byte)0, animated);
    }

    public void moveCenterAndZoom(double moveHorizontal, double moveVertical, byte zoomLevelDiff) {
        this.moveCenterAndZoom(moveHorizontal, moveVertical, zoomLevelDiff, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveCenterAndZoom(double moveHorizontal, double moveVertical, byte zoomLevelDiff, boolean animated) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            long mapSize = MercatorProjection.getMapSize(this.zoomLevel, this.displayModel.getTileSize());
            double pixelX = MercatorProjection.longitudeToPixelX(this.longitude, mapSize) - moveHorizontal;
            double pixelY = MercatorProjection.latitudeToPixelY(this.latitude, mapSize) - moveVertical;
            pixelX = Math.min(Math.max(0.0, pixelX), (double)mapSize);
            pixelY = Math.min(Math.max(0.0, pixelY), (double)mapSize);
            double newLatitude = MercatorProjection.pixelYToLatitude(pixelY, mapSize);
            double newLongitude = MercatorProjection.pixelXToLongitude(pixelX, mapSize);
            this.setCenterInternal(newLatitude, newLongitude);
            this.setZoomLevelInternal(this.zoomLevel + zoomLevelDiff, animated);
        }
        this.notifyObservers();
    }

    @Override
    public synchronized void save(PreferencesFacade preferencesFacade) {
        preferencesFacade.putDouble(LATITUDE, this.latitude);
        preferencesFacade.putDouble(LONGITUDE, this.longitude);
        if (this.mapLimit == null) {
            preferencesFacade.putDouble(LATITUDE_MAX, Double.NaN);
            preferencesFacade.putDouble(LATITUDE_MIN, Double.NaN);
            preferencesFacade.putDouble(LONGITUDE_MAX, Double.NaN);
            preferencesFacade.putDouble(LONGITUDE_MIN, Double.NaN);
        } else {
            preferencesFacade.putDouble(LATITUDE_MAX, this.mapLimit.maxLatitude);
            preferencesFacade.putDouble(LATITUDE_MIN, this.mapLimit.minLatitude);
            preferencesFacade.putDouble(LONGITUDE_MAX, this.mapLimit.maxLongitude);
            preferencesFacade.putDouble(LONGITUDE_MIN, this.mapLimit.minLongitude);
        }
        preferencesFacade.putByte(ZOOM_LEVEL, this.zoomLevel);
        preferencesFacade.putByte(ZOOM_LEVEL_MAX, this.zoomLevelMax);
        preferencesFacade.putByte(ZOOM_LEVEL_MIN, this.zoomLevelMin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCenter(LatLong latLong) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            this.setCenterInternal(latLong.latitude, latLong.longitude);
        }
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapLimit(BoundingBox mapLimit) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            this.mapLimit = mapLimit;
        }
        this.notifyObservers();
    }

    public void setMapPosition(MapPosition mapPosition) {
        this.setMapPosition(mapPosition, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMapPosition(MapPosition mapPosition, boolean animated) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            this.setCenterInternal(mapPosition.latLong.latitude, mapPosition.latLong.longitude);
            this.setZoomLevelInternal(mapPosition.zoomLevel, animated);
        }
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPivot(LatLong pivot) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            this.pivot = pivot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScaleFactor(double scaleFactor) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            this.scaleFactor = scaleFactor;
        }
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScaleFactorAdjustment(double adjustment) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            this.setScaleFactor(Math.pow(2.0, this.zoomLevel) * adjustment);
        }
        this.notifyObservers();
    }

    public void setZoomLevel(byte zoomLevel) {
        this.setZoomLevel(zoomLevel, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoomLevel(byte zoomLevel, boolean animated) {
        if (zoomLevel < 0) {
            throw new IllegalArgumentException("zoomLevel must not be negative: " + zoomLevel);
        }
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            this.setZoomLevelInternal(zoomLevel, animated);
        }
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoomLevelMax(byte zoomLevelMax) {
        if (zoomLevelMax < 0) {
            throw new IllegalArgumentException("zoomLevelMax must not be negative: " + zoomLevelMax);
        }
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            if (zoomLevelMax < this.zoomLevelMin) {
                throw new IllegalArgumentException("zoomLevelMax must be >= zoomLevelMin: " + zoomLevelMax);
            }
            this.zoomLevelMax = zoomLevelMax;
        }
        this.notifyObservers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZoomLevelMin(byte zoomLevelMin) {
        if (zoomLevelMin < 0) {
            throw new IllegalArgumentException("zoomLevelMin must not be negative: " + zoomLevelMin);
        }
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            if (zoomLevelMin > this.zoomLevelMax) {
                throw new IllegalArgumentException("zoomLevelMin must be <= zoomLevelMax: " + zoomLevelMin);
            }
            this.zoomLevelMin = zoomLevelMin;
        }
        this.notifyObservers();
    }

    public void zoom(byte zoomLevelDiff) {
        this.zoom(zoomLevelDiff, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zoom(byte zoomLevelDiff, boolean animated) {
        MapViewPosition mapViewPosition = this;
        synchronized (mapViewPosition) {
            this.setZoomLevelInternal(this.zoomLevel + zoomLevelDiff, animated);
        }
        this.notifyObservers();
    }

    public void zoomIn() {
        this.zoomIn(true);
    }

    public void zoomIn(boolean animated) {
        this.zoom((byte)1, animated);
    }

    public void zoomOut() {
        this.zoomOut(true);
    }

    public void zoomOut(boolean animated) {
        this.zoom((byte)-1, animated);
    }

    private void setCenterInternal(double latitude, double longitude) {
        if (this.mapLimit == null) {
            this.latitude = latitude;
            this.longitude = longitude;
        } else {
            this.latitude = Math.max(Math.min(latitude, this.mapLimit.maxLatitude), this.mapLimit.minLatitude);
            this.longitude = Math.max(Math.min(longitude, this.mapLimit.maxLongitude), this.mapLimit.minLongitude);
        }
    }

    private void setZoomLevelInternal(int zoomLevel, boolean animated) {
        this.zoomLevel = (byte)Math.max(Math.min(zoomLevel, this.zoomLevelMax), this.zoomLevelMin);
        if (animated) {
            this.zoomAnimator.startAnimation(this.getScaleFactor(), Math.pow(2.0, this.zoomLevel));
        } else {
            this.setScaleFactor(Math.pow(2.0, this.zoomLevel));
            this.setPivot(null);
        }
    }

    private class ZoomAnimator
    extends PausableThread {
        private static final int DEFAULT_DURATION = 250;
        private static final int FRAME_LENGTH_IN_MS = 15;
        double scaleDifference;
        double startScaleFactor;
        private boolean executeAnimation;
        private long timeEnd;
        private long timeStart;

        private ZoomAnimator() {
        }

        @Override
        protected void doWork() throws InterruptedException {
            if (System.currentTimeMillis() >= this.timeEnd) {
                this.executeAnimation = false;
                MapViewPosition.this.setScaleFactor(this.calculateScaleFactor(1.0f));
                MapViewPosition.this.setPivot(null);
            } else {
                float timeElapsedRatio = (float)(System.currentTimeMillis() - this.timeStart) / 250.0f;
                MapViewPosition.this.setScaleFactor(this.calculateScaleFactor(timeElapsedRatio));
            }
            ZoomAnimator.sleep(15L);
        }

        @Override
        protected PausableThread.ThreadPriority getThreadPriority() {
            return PausableThread.ThreadPriority.ABOVE_NORMAL;
        }

        @Override
        protected boolean hasWork() {
            return this.executeAnimation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startAnimation(double startScaleFactor, double targetScaleFactor) {
            this.startScaleFactor = startScaleFactor;
            this.scaleDifference = targetScaleFactor - this.startScaleFactor;
            this.executeAnimation = true;
            this.timeStart = System.currentTimeMillis();
            this.timeEnd = this.timeStart + 250L;
            ZoomAnimator zoomAnimator = this;
            synchronized (zoomAnimator) {
                this.notify();
            }
        }

        private double calculateScaleFactor(float percent) {
            return this.startScaleFactor + this.scaleDifference * (double)percent;
        }
    }
}

