/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Map;
import org.mapsforge.core.util.LRUCache;
import org.mapsforge.map.reader.Deserializer;
import org.mapsforge.map.reader.IndexCacheEntryKey;
import org.mapsforge.map.reader.header.SubFileParameter;

class IndexCache {
    private static final int INDEX_ENTRIES_PER_BLOCK = 128;
    private static final int SIZE_OF_INDEX_BLOCK = 640;
    private final Map<IndexCacheEntryKey, byte[]> map;
    private final RandomAccessFile randomAccessFile;

    IndexCache(RandomAccessFile randomAccessFile, int capacity) {
        this.randomAccessFile = randomAccessFile;
        this.map = new LRUCache<IndexCacheEntryKey, byte[]>(capacity);
    }

    void destroy() {
        this.map.clear();
    }

    long getIndexEntry(SubFileParameter subFileParameter, long blockNumber) throws IOException {
        if (blockNumber >= subFileParameter.numberOfBlocks) {
            throw new IOException("invalid block number: " + blockNumber);
        }
        long indexBlockNumber = blockNumber / 128L;
        IndexCacheEntryKey indexCacheEntryKey = new IndexCacheEntryKey(subFileParameter, indexBlockNumber);
        byte[] indexBlock = this.map.get(indexCacheEntryKey);
        if (indexBlock == null) {
            long indexBlockPosition = subFileParameter.indexStartAddress + indexBlockNumber * 640L;
            int remainingIndexSize = (int)(subFileParameter.indexEndAddress - indexBlockPosition);
            int indexBlockSize = Math.min(640, remainingIndexSize);
            indexBlock = new byte[indexBlockSize];
            this.randomAccessFile.seek(indexBlockPosition);
            if (this.randomAccessFile.read(indexBlock, 0, indexBlockSize) != indexBlockSize) {
                throw new IOException("could not read index block with size: " + indexBlockSize);
            }
            this.map.put(indexCacheEntryKey, indexBlock);
        }
        long indexEntryInBlock = blockNumber % 128L;
        int addressInIndexBlock = (int)(indexEntryInBlock * 5L);
        return Deserializer.getFiveBytesLong(indexBlock, addressInIndexBlock);
    }
}

