/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader;

import org.mapsforge.core.model.Tile;

final class QueryCalculations {
    static int calculateTileBitmask(Tile tile, int zoomLevelDifference) {
        if (zoomLevelDifference == 1) {
            return QueryCalculations.getFirstLevelTileBitmask(tile);
        }
        long subtileX = tile.tileX >>> zoomLevelDifference - 2;
        long subtileY = tile.tileY >>> zoomLevelDifference - 2;
        long parentTileX = subtileX >>> 1;
        long parentTileY = subtileY >>> 1;
        if (parentTileX % 2L == 0L && parentTileY % 2L == 0L) {
            return QueryCalculations.getSecondLevelTileBitmaskUpperLeft(subtileX, subtileY);
        }
        if (parentTileX % 2L == 1L && parentTileY % 2L == 0L) {
            return QueryCalculations.getSecondLevelTileBitmaskUpperRight(subtileX, subtileY);
        }
        if (parentTileX % 2L == 0L && parentTileY % 2L == 1L) {
            return QueryCalculations.getSecondLevelTileBitmaskLowerLeft(subtileX, subtileY);
        }
        return QueryCalculations.getSecondLevelTileBitmaskLowerRight(subtileX, subtileY);
    }

    private static int getFirstLevelTileBitmask(Tile tile) {
        if (tile.tileX % 2 == 0 && tile.tileY % 2 == 0) {
            return 52224;
        }
        if (tile.tileX % 2 == 1 && tile.tileY % 2 == 0) {
            return 13056;
        }
        if (tile.tileX % 2 == 0 && tile.tileY % 2 == 1) {
            return 204;
        }
        return 51;
    }

    private static int getSecondLevelTileBitmaskLowerLeft(long subtileX, long subtileY) {
        if (subtileX % 2L == 0L && subtileY % 2L == 0L) {
            return 128;
        }
        if (subtileX % 2L == 1L && subtileY % 2L == 0L) {
            return 64;
        }
        if (subtileX % 2L == 0L && subtileY % 2L == 1L) {
            return 8;
        }
        return 4;
    }

    private static int getSecondLevelTileBitmaskLowerRight(long subtileX, long subtileY) {
        if (subtileX % 2L == 0L && subtileY % 2L == 0L) {
            return 32;
        }
        if (subtileX % 2L == 1L && subtileY % 2L == 0L) {
            return 16;
        }
        if (subtileX % 2L == 0L && subtileY % 2L == 1L) {
            return 2;
        }
        return 1;
    }

    private static int getSecondLevelTileBitmaskUpperLeft(long subtileX, long subtileY) {
        if (subtileX % 2L == 0L && subtileY % 2L == 0L) {
            return 32768;
        }
        if (subtileX % 2L == 1L && subtileY % 2L == 0L) {
            return 16384;
        }
        if (subtileX % 2L == 0L && subtileY % 2L == 1L) {
            return 2048;
        }
        return 1024;
    }

    private static int getSecondLevelTileBitmaskUpperRight(long subtileX, long subtileY) {
        if (subtileX % 2L == 0L && subtileY % 2L == 0L) {
            return 8192;
        }
        if (subtileX % 2L == 1L && subtileY % 2L == 0L) {
            return 4096;
        }
        if (subtileX % 2L == 0L && subtileY % 2L == 1L) {
            return 512;
        }
        return 256;
    }

    private QueryCalculations() {
        throw new IllegalStateException();
    }
}

