/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader;

import org.mapsforge.core.model.Tile;
import org.mapsforge.map.reader.QueryCalculations;
import org.mapsforge.map.reader.header.SubFileParameter;

class QueryParameters {
    long fromBaseTileX;
    long fromBaseTileY;
    long fromBlockX;
    long fromBlockY;
    int queryTileBitmask;
    int queryZoomLevel;
    long toBaseTileX;
    long toBaseTileY;
    long toBlockX;
    long toBlockY;
    boolean useTileBitmask;

    QueryParameters() {
    }

    public void calculateBaseTiles(Tile tile, SubFileParameter subFileParameter) {
        if (tile.zoomLevel < subFileParameter.baseZoomLevel) {
            int zoomLevelDifference = subFileParameter.baseZoomLevel - tile.zoomLevel;
            this.fromBaseTileX = tile.tileX << zoomLevelDifference;
            this.fromBaseTileY = tile.tileY << zoomLevelDifference;
            this.toBaseTileX = this.fromBaseTileX + (long)(1 << zoomLevelDifference) - 1L;
            this.toBaseTileY = this.fromBaseTileY + (long)(1 << zoomLevelDifference) - 1L;
            this.useTileBitmask = false;
        } else if (tile.zoomLevel > subFileParameter.baseZoomLevel) {
            int zoomLevelDifference = tile.zoomLevel - subFileParameter.baseZoomLevel;
            this.fromBaseTileX = tile.tileX >>> zoomLevelDifference;
            this.fromBaseTileY = tile.tileY >>> zoomLevelDifference;
            this.toBaseTileX = this.fromBaseTileX;
            this.toBaseTileY = this.fromBaseTileY;
            this.useTileBitmask = true;
            this.queryTileBitmask = QueryCalculations.calculateTileBitmask(tile, zoomLevelDifference);
        } else {
            this.fromBaseTileX = tile.tileX;
            this.fromBaseTileY = tile.tileY;
            this.toBaseTileX = this.fromBaseTileX;
            this.toBaseTileY = this.fromBaseTileY;
            this.useTileBitmask = false;
        }
    }

    public void calculateBlocks(SubFileParameter subFileParameter) {
        this.fromBlockX = Math.max(this.fromBaseTileX - subFileParameter.boundaryTileLeft, 0L);
        this.fromBlockY = Math.max(this.fromBaseTileY - subFileParameter.boundaryTileTop, 0L);
        this.toBlockX = Math.min(this.toBaseTileX - subFileParameter.boundaryTileLeft, subFileParameter.blocksWidth - 1L);
        this.toBlockY = Math.min(this.toBaseTileY - subFileParameter.boundaryTileTop, subFileParameter.blocksHeight - 1L);
    }
}

