/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader.header;

import java.io.IOException;
import org.mapsforge.map.reader.ReadBuffer;
import org.mapsforge.map.reader.header.MapFileException;
import org.mapsforge.map.reader.header.MapFileInfo;
import org.mapsforge.map.reader.header.MapFileInfoBuilder;
import org.mapsforge.map.reader.header.OptionalFields;
import org.mapsforge.map.reader.header.RequiredFields;
import org.mapsforge.map.reader.header.SubFileParameter;
import org.mapsforge.map.reader.header.SubFileParameterBuilder;

public class MapFileHeader {
    private static final int BASE_ZOOM_LEVEL_MAX = 20;
    private static final int HEADER_SIZE_MIN = 70;
    private static final byte SIGNATURE_LENGTH_INDEX = 16;
    private static final char SPACE = ' ';
    private MapFileInfo mapFileInfo;
    private SubFileParameter[] subFileParameters;
    private byte zoomLevelMaximum;
    private byte zoomLevelMinimum;

    public MapFileInfo getMapFileInfo() {
        return this.mapFileInfo;
    }

    public byte getQueryZoomLevel(byte zoomLevel) {
        if (zoomLevel > this.zoomLevelMaximum) {
            return this.zoomLevelMaximum;
        }
        if (zoomLevel < this.zoomLevelMinimum) {
            return this.zoomLevelMinimum;
        }
        return zoomLevel;
    }

    public SubFileParameter getSubFileParameter(int queryZoomLevel) {
        return this.subFileParameters[queryZoomLevel];
    }

    public void readHeader(ReadBuffer readBuffer, long fileSize) throws IOException {
        RequiredFields.readMagicByte(readBuffer);
        RequiredFields.readRemainingHeader(readBuffer);
        MapFileInfoBuilder mapFileInfoBuilder = new MapFileInfoBuilder();
        RequiredFields.readFileVersion(readBuffer, mapFileInfoBuilder);
        RequiredFields.readFileSize(readBuffer, fileSize, mapFileInfoBuilder);
        RequiredFields.readMapDate(readBuffer, mapFileInfoBuilder);
        RequiredFields.readBoundingBox(readBuffer, mapFileInfoBuilder);
        RequiredFields.readTilePixelSize(readBuffer, mapFileInfoBuilder);
        RequiredFields.readProjectionName(readBuffer, mapFileInfoBuilder);
        OptionalFields.readOptionalFields(readBuffer, mapFileInfoBuilder);
        RequiredFields.readPoiTags(readBuffer, mapFileInfoBuilder);
        RequiredFields.readWayTags(readBuffer, mapFileInfoBuilder);
        this.readSubFileParameters(readBuffer, fileSize, mapFileInfoBuilder);
        this.mapFileInfo = mapFileInfoBuilder.build();
    }

    private void readSubFileParameters(ReadBuffer readBuffer, long fileSize, MapFileInfoBuilder mapFileInfoBuilder) {
        int numberOfSubFiles = readBuffer.readByte();
        if (numberOfSubFiles < 1) {
            throw new MapFileException("invalid number of sub-files: " + numberOfSubFiles);
        }
        mapFileInfoBuilder.numberOfSubFiles = numberOfSubFiles;
        SubFileParameter[] tempSubFileParameters = new SubFileParameter[numberOfSubFiles];
        this.zoomLevelMinimum = (byte)127;
        this.zoomLevelMaximum = (byte)-128;
        for (int currentSubFile = 0; currentSubFile < numberOfSubFiles; currentSubFile = (int)((byte)(currentSubFile + 1))) {
            SubFileParameterBuilder subFileParameterBuilder = new SubFileParameterBuilder();
            byte baseZoomLevel = readBuffer.readByte();
            if (baseZoomLevel < 0 || baseZoomLevel > 20) {
                throw new MapFileException("invalid base zoom level: " + baseZoomLevel);
            }
            subFileParameterBuilder.baseZoomLevel = baseZoomLevel;
            byte zoomLevelMin = readBuffer.readByte();
            if (zoomLevelMin < 0 || zoomLevelMin > 22) {
                throw new MapFileException("invalid minimum zoom level: " + zoomLevelMin);
            }
            subFileParameterBuilder.zoomLevelMin = zoomLevelMin;
            byte zoomLevelMax = readBuffer.readByte();
            if (zoomLevelMax < 0 || zoomLevelMax > 22) {
                throw new MapFileException("invalid maximum zoom level: " + zoomLevelMax);
            }
            subFileParameterBuilder.zoomLevelMax = zoomLevelMax;
            if (zoomLevelMin > zoomLevelMax) {
                throw new MapFileException("invalid zoom level range: " + zoomLevelMin + ' ' + zoomLevelMax);
            }
            long startAddress = readBuffer.readLong();
            if (startAddress < 70L || startAddress >= fileSize) {
                throw new MapFileException("invalid start address: " + startAddress);
            }
            subFileParameterBuilder.startAddress = startAddress;
            long indexStartAddress = startAddress;
            if (mapFileInfoBuilder.optionalFields.isDebugFile) {
                indexStartAddress += 16L;
            }
            subFileParameterBuilder.indexStartAddress = indexStartAddress;
            long subFileSize = readBuffer.readLong();
            if (subFileSize < 1L) {
                throw new MapFileException("invalid sub-file size: " + subFileSize);
            }
            subFileParameterBuilder.subFileSize = subFileSize;
            subFileParameterBuilder.boundingBox = mapFileInfoBuilder.boundingBox;
            tempSubFileParameters[currentSubFile] = subFileParameterBuilder.build();
            if (this.zoomLevelMinimum > tempSubFileParameters[currentSubFile].zoomLevelMin) {
                mapFileInfoBuilder.zoomLevelMin = this.zoomLevelMinimum = tempSubFileParameters[currentSubFile].zoomLevelMin;
            }
            if (this.zoomLevelMaximum >= tempSubFileParameters[currentSubFile].zoomLevelMax) continue;
            mapFileInfoBuilder.zoomLevelMax = this.zoomLevelMaximum = tempSubFileParameters[currentSubFile].zoomLevelMax;
        }
        this.subFileParameters = new SubFileParameter[this.zoomLevelMaximum + 1];
        for (int currentMapFile = 0; currentMapFile < numberOfSubFiles; ++currentMapFile) {
            SubFileParameter subFileParameter = tempSubFileParameters[currentMapFile];
            for (byte zoomLevel = subFileParameter.zoomLevelMin; zoomLevel <= subFileParameter.zoomLevelMax; zoomLevel = (byte)(zoomLevel + 1)) {
                this.subFileParameters[zoomLevel] = subFileParameter;
            }
        }
    }
}

