/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.reader.header;

import java.io.IOException;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Tag;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.map.reader.ReadBuffer;
import org.mapsforge.map.reader.header.MapFileException;
import org.mapsforge.map.reader.header.MapFileInfoBuilder;

final class RequiredFields {
    private static final String BINARY_OSM_MAGIC_BYTE = "mapsforge binary OSM";
    private static final int HEADER_SIZE_MAX = 1000000;
    private static final int HEADER_SIZE_MIN = 70;
    private static final String MERCATOR = "Mercator";
    private static final int SUPPORTED_FILE_VERSION_MIN = 3;
    private static final int SUPPORTED_FILE_VERSION_MAX = 4;

    static void readBoundingBox(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        double minLatitude = LatLongUtils.microdegreesToDegrees(readBuffer.readInt());
        double minLongitude = LatLongUtils.microdegreesToDegrees(readBuffer.readInt());
        double maxLatitude = LatLongUtils.microdegreesToDegrees(readBuffer.readInt());
        double maxLongitude = LatLongUtils.microdegreesToDegrees(readBuffer.readInt());
        try {
            mapFileInfoBuilder.boundingBox = new BoundingBox(minLatitude, minLongitude, maxLatitude, maxLongitude);
        }
        catch (IllegalArgumentException e) {
            throw new MapFileException(e.getMessage());
        }
    }

    static void readFileSize(ReadBuffer readBuffer, long fileSize, MapFileInfoBuilder mapFileInfoBuilder) {
        long headerFileSize = readBuffer.readLong();
        if (headerFileSize != fileSize) {
            throw new MapFileException("invalid file size: " + headerFileSize);
        }
        mapFileInfoBuilder.fileSize = fileSize;
    }

    static void readFileVersion(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int fileVersion = readBuffer.readInt();
        if (fileVersion < 3 || fileVersion > 4) {
            throw new MapFileException("unsupported file version: " + fileVersion);
        }
        mapFileInfoBuilder.fileVersion = fileVersion;
    }

    static void readMagicByte(ReadBuffer readBuffer) throws IOException {
        int magicByteLength = BINARY_OSM_MAGIC_BYTE.length();
        if (!readBuffer.readFromFile(magicByteLength + 4)) {
            throw new MapFileException("reading magic byte has failed");
        }
        String magicByte = readBuffer.readUTF8EncodedString(magicByteLength);
        if (!BINARY_OSM_MAGIC_BYTE.equals(magicByte)) {
            throw new MapFileException("invalid magic byte: " + magicByte);
        }
    }

    static void readMapDate(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        long mapDate = readBuffer.readLong();
        if (mapDate < 1200000000000L) {
            throw new MapFileException("invalid map date: " + mapDate);
        }
        mapFileInfoBuilder.mapDate = mapDate;
    }

    static void readPoiTags(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int numberOfPoiTags = readBuffer.readShort();
        if (numberOfPoiTags < 0) {
            throw new MapFileException("invalid number of POI tags: " + numberOfPoiTags);
        }
        Tag[] poiTags = new Tag[numberOfPoiTags];
        for (int currentTagId = 0; currentTagId < numberOfPoiTags; ++currentTagId) {
            String tag = readBuffer.readUTF8EncodedString();
            if (tag == null) {
                throw new MapFileException("POI tag must not be null: " + currentTagId);
            }
            poiTags[currentTagId] = new Tag(tag);
        }
        mapFileInfoBuilder.poiTags = poiTags;
    }

    static void readProjectionName(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        String projectionName = readBuffer.readUTF8EncodedString();
        if (!MERCATOR.equals(projectionName)) {
            throw new MapFileException("unsupported projection: " + projectionName);
        }
        mapFileInfoBuilder.projectionName = projectionName;
    }

    static void readRemainingHeader(ReadBuffer readBuffer) throws IOException {
        int remainingHeaderSize = readBuffer.readInt();
        if (remainingHeaderSize < 70 || remainingHeaderSize > 1000000) {
            throw new MapFileException("invalid remaining header size: " + remainingHeaderSize);
        }
        if (!readBuffer.readFromFile(remainingHeaderSize)) {
            throw new MapFileException("reading header data has failed: " + remainingHeaderSize);
        }
    }

    static void readTilePixelSize(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int tilePixelSize;
        mapFileInfoBuilder.tilePixelSize = tilePixelSize = readBuffer.readShort();
    }

    static void readWayTags(ReadBuffer readBuffer, MapFileInfoBuilder mapFileInfoBuilder) {
        int numberOfWayTags = readBuffer.readShort();
        if (numberOfWayTags < 0) {
            throw new MapFileException("invalid number of way tags: " + numberOfWayTags);
        }
        Tag[] wayTags = new Tag[numberOfWayTags];
        for (int currentTagId = 0; currentTagId < numberOfWayTags; ++currentTagId) {
            String tag = readBuffer.readUTF8EncodedString();
            if (tag == null) {
                throw new MapFileException("way tag must not be null: " + currentTagId);
            }
            wayTags[currentTagId] = new Tag(tag);
        }
        mapFileInfoBuilder.wayTags = wayTags;
    }

    private RequiredFields() {
        throw new IllegalStateException();
    }
}

