/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.map.layer.renderer.CanvasRasterer;
import org.mapsforge.map.layer.renderer.RendererJob;
import org.mapsforge.map.layer.renderer.ShapePaintContainer;
import org.mapsforge.map.rendertheme.rule.RenderTheme;

public class RenderContext {
    private static final byte LAYERS = 11;
    private static final double STROKE_INCREASE = 1.5;
    private static final byte STROKE_MIN_ZOOM_LEVEL = 12;
    public final RenderTheme renderTheme;
    public final RendererJob rendererJob;
    public final CanvasRasterer canvasRasterer;
    private List<List<ShapePaintContainer>> drawingLayers;
    public final List<MapElementContainer> labels;
    public final List<List<List<ShapePaintContainer>>> ways;

    public RenderContext(RenderTheme renderTheme, RendererJob rendererJob, CanvasRasterer canvasRasterer) {
        this.rendererJob = rendererJob;
        this.labels = new LinkedList<MapElementContainer>();
        this.renderTheme = renderTheme;
        this.canvasRasterer = canvasRasterer;
        this.ways = this.createWayLists();
        this.setScaleStrokeWidth(rendererJob.tile.zoomLevel);
        renderTheme.scaleTextSize(rendererJob.textScale, this.rendererJob.tile.zoomLevel);
    }

    public void destroy() {
        this.canvasRasterer.destroy();
    }

    public void setDrawingLayers(byte layer) {
        if (layer < 0) {
            layer = 0;
        } else if (layer >= 11) {
            layer = (byte)10;
        }
        this.drawingLayers = this.ways.get(layer);
    }

    public void addToCurrentDrawingLayer(int level, ShapePaintContainer element) {
        this.drawingLayers.get(level).add(element);
    }

    private List<List<List<ShapePaintContainer>>> createWayLists() {
        ArrayList<List<List<ShapePaintContainer>>> result = new ArrayList<List<List<ShapePaintContainer>>>(11);
        int levels = this.renderTheme.getLevels();
        for (int i = 10; i >= 0; i = (int)((byte)(i - 1))) {
            ArrayList innerWayList = new ArrayList(levels);
            for (int j = levels - 1; j >= 0; --j) {
                innerWayList.add(new ArrayList(0));
            }
            result.add(innerWayList);
        }
        return result;
    }

    private void setScaleStrokeWidth(byte zoomLevel) {
        int zoomLevelDiff = Math.max(zoomLevel - 12, 0);
        this.renderTheme.scaleStrokeWidth((float)Math.pow(1.5, zoomLevelDiff), this.rendererJob.tile.zoomLevel);
    }
}

