/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.ResourceBitmap;
import org.mapsforge.map.model.DisplayModel;
import org.xmlpull.v1.XmlPullParserException;

public final class XmlUtils {
    public static boolean supportOlderRenderThemes = true;
    private static final String PREFIX_FILE = "file:";
    private static final String PREFIX_JAR = "jar:";
    private static final String PREFIX_JAR_V1 = "jar:/org/mapsforge/android/maps/rendertheme";
    private static final String UNSUPPORTED_COLOR_FORMAT = "unsupported color format: ";

    public static void checkMandatoryAttribute(String elementName, String attributeName, Object attributeValue) throws XmlPullParserException {
        if (attributeValue == null) {
            throw new XmlPullParserException("missing attribute '" + attributeName + "' for element: " + elementName);
        }
    }

    /*
     * Loose catch block
     */
    public static ResourceBitmap createBitmap(GraphicFactory graphicFactory, DisplayModel displayModel, String relativePathPrefix, String src, int width, int height, int percent) throws IOException {
        if (src == null || src.length() == 0) {
            return null;
        }
        InputStream inputStream = graphicFactory.platformSpecificSources(relativePathPrefix, src);
        if (inputStream == null) {
            inputStream = XmlUtils.createInputStream(relativePathPrefix, src);
        }
        String absoluteName = XmlUtils.getAbsoluteName(relativePathPrefix, src);
        int hash = (absoluteName + width + height + percent).hashCode();
        if (src.endsWith(".svg")) {
            try {
                ResourceBitmap resourceBitmap = graphicFactory.renderSvg(inputStream, displayModel.getScaleFactor(), width, height, percent, hash);
                return resourceBitmap;
            }
            catch (IOException e) {
                throw new IOException("SVG render failed " + src, e);
            }
        }
        ResourceBitmap e = graphicFactory.createResourceBitmap(inputStream, absoluteName.hashCode());
        return e;
        catch (IOException e2) {
            throw new IOException("Reading bitmap file failed " + src, e2);
        }
        finally {
            inputStream.close();
        }
    }

    public static XmlPullParserException createXmlPullParserException(String element, String name, String value, int attributeIndex) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("unknown attribute (");
        stringBuilder.append(attributeIndex);
        stringBuilder.append(") in element '");
        stringBuilder.append(element);
        stringBuilder.append("': ");
        stringBuilder.append(name);
        stringBuilder.append('=');
        stringBuilder.append(value);
        return new XmlPullParserException(stringBuilder.toString());
    }

    public static int getColor(GraphicFactory graphicFactory, String colorString) {
        if (colorString.isEmpty() || colorString.charAt(0) != '#') {
            throw new IllegalArgumentException(UNSUPPORTED_COLOR_FORMAT + colorString);
        }
        if (colorString.length() == 7) {
            return XmlUtils.getColor(graphicFactory, colorString, 255, 1);
        }
        if (colorString.length() == 9) {
            return XmlUtils.getColor(graphicFactory, colorString, Integer.parseInt(colorString.substring(1, 3), 16), 3);
        }
        throw new IllegalArgumentException(UNSUPPORTED_COLOR_FORMAT + colorString);
    }

    public static byte parseNonNegativeByte(String name, String value) throws XmlPullParserException {
        byte parsedByte = Byte.parseByte(value);
        XmlUtils.checkForNegativeValue(name, parsedByte);
        return parsedByte;
    }

    public static float parseNonNegativeFloat(String name, String value) throws XmlPullParserException {
        float parsedFloat = Float.parseFloat(value);
        XmlUtils.checkForNegativeValue(name, parsedFloat);
        return parsedFloat;
    }

    public static int parseNonNegativeInteger(String name, String value) throws XmlPullParserException {
        int parsedInt = Integer.parseInt(value);
        XmlUtils.checkForNegativeValue(name, parsedInt);
        return parsedInt;
    }

    private static void checkForNegativeValue(String name, float value) throws XmlPullParserException {
        if (value < 0.0f) {
            throw new XmlPullParserException("Attribute '" + name + "' must not be negative: " + value);
        }
    }

    private static InputStream createInputStream(String relativePathPrefix, String src) throws FileNotFoundException {
        if (src.startsWith(PREFIX_JAR)) {
            String prefixJar = !supportOlderRenderThemes ? PREFIX_JAR : (src.startsWith(PREFIX_JAR_V1) ? PREFIX_JAR_V1 : PREFIX_JAR);
            String absoluteName = XmlUtils.getAbsoluteName(relativePathPrefix, src.substring(prefixJar.length()));
            InputStream inputStream = XmlUtils.class.getResourceAsStream(absoluteName);
            if (inputStream == null) {
                throw new FileNotFoundException("resource not found: " + absoluteName);
            }
            return inputStream;
        }
        if (src.startsWith(PREFIX_FILE)) {
            File file = XmlUtils.getFile(relativePathPrefix, src.substring(PREFIX_FILE.length()));
            if (!file.exists()) {
                String pathName = src.substring(PREFIX_FILE.length());
                if (pathName.length() > 0 && pathName.charAt(0) == File.separatorChar) {
                    file = XmlUtils.getFile(relativePathPrefix, pathName.substring(1));
                }
                if (!file.exists()) {
                    throw new FileNotFoundException("file does not exist: " + file.getAbsolutePath());
                }
            } else {
                if (!file.isFile()) {
                    throw new FileNotFoundException("not a file: " + file.getAbsolutePath());
                }
                if (!file.canRead()) {
                    throw new FileNotFoundException("cannot read file: " + file.getAbsolutePath());
                }
            }
            return new FileInputStream(file);
        }
        throw new FileNotFoundException("invalid bitmap source: " + src);
    }

    private static String getAbsoluteName(String relativePathPrefix, String name) {
        if (name.charAt(0) == '/') {
            return name;
        }
        return relativePathPrefix + name;
    }

    private static int getColor(GraphicFactory graphicFactory, String colorString, int alpha, int rgbStartIndex) {
        int red = Integer.parseInt(colorString.substring(rgbStartIndex, rgbStartIndex + 2), 16);
        int green = Integer.parseInt(colorString.substring(rgbStartIndex + 2, rgbStartIndex + 4), 16);
        int blue = Integer.parseInt(colorString.substring(rgbStartIndex + 4, rgbStartIndex + 6), 16);
        return graphicFactory.createColor(alpha, red, green, blue);
    }

    private static File getFile(String parentPath, String pathName) {
        if (pathName.charAt(0) == File.separatorChar) {
            return new File(pathName);
        }
        return new File(parentPath, pathName);
    }

    private XmlUtils() {
        throw new IllegalStateException();
    }
}

